/*
 * Decompiled with CFR 0.152.
 */
package drr.base.util.party.functions;

import cdm.base.staticdata.party.Counterparty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.TradeForEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=CounterpartiesForEventDefault.class)
public abstract class CounterpartiesForEvent
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends Counterparty> evaluate(ReportableEventBase reportableEvent) {
        List counterparties;
        List<Counterparty.CounterpartyBuilder> counterpartiesBuilder = this.doEvaluate(reportableEvent);
        if (counterpartiesBuilder == null) {
            counterparties = null;
        } else {
            counterparties = counterpartiesBuilder.stream().map(Counterparty::build).collect(Collectors.toList());
            this.objectValidator.validate(Counterparty.class, counterparties);
        }
        return counterparties;
    }

    protected abstract List<Counterparty.CounterpartyBuilder> doEvaluate(ReportableEventBase var1);

    public static class CounterpartiesForEventDefault
    extends CounterpartiesForEvent {
        @Override
        protected List<Counterparty.CounterpartyBuilder> doEvaluate(ReportableEventBase reportableEvent) {
            ArrayList<Counterparty.CounterpartyBuilder> counterparties = new ArrayList<Counterparty.CounterpartyBuilder>();
            return this.assignOutput(counterparties, reportableEvent);
        }

        protected List<Counterparty.CounterpartyBuilder> assignOutput(List<Counterparty.CounterpartyBuilder> counterparties, ReportableEventBase reportableEvent) {
            counterparties.addAll(this.toBuilder(MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent)).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti()));
            return Optional.ofNullable(counterparties).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

