/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.common.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.enrichment.common.EnrichmentData;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EnrichmentDataOnlyExistsValidator
implements ValidatorWithArg<EnrichmentData, Set<String>> {
    public <T2 extends EnrichmentData> ValidationResult<EnrichmentData> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"micData", (Object)ExistenceChecker.isSet(o.getMicData())).put((Object)"leiData", (Object)ExistenceChecker.isSet(o.getLeiData())).put((Object)"upiData", (Object)ExistenceChecker.isSet(o.getUpiData())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"EnrichmentData", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"EnrichmentData", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"EnrichmentData", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"EnrichmentData", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

