/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.eic.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.enrichment.eic.functions.GetAcceptedEicCodes;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=IsAcceptedEicCodeDefault.class)
public abstract class IsAcceptedEicCode
implements RosettaFunction {
    @Inject
    protected GetAcceptedEicCodes getAcceptedEicCodes;

    public Boolean evaluate(List<String> eicCode) {
        Boolean result = this.doEvaluate(eicCode);
        return result;
    }

    protected abstract Boolean doEvaluate(List<String> var1);

    public static class IsAcceptedEicCodeDefault
    extends IsAcceptedEicCode {
        @Override
        protected Boolean doEvaluate(List<String> eicCode) {
            if (eicCode == null) {
                eicCode = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, eicCode);
        }

        protected Boolean assignOutput(Boolean result, List<String> eicCode) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(eicCode)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg0 = MapperC.of(eicCode);
                MapperC thenArg1 = thenArg0.mapItem(ec -> ExpressionOperatorsNullSafe.contains((Mapper)MapperC.of(this.getAcceptedEicCodes.evaluate()), (Mapper)ec).asMapper());
                result = (Boolean)ExpressionOperatorsNullSafe.areEqual((Mapper)thenArg1, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper().get();
            } else {
                result = false;
            }
            return result;
        }
    }
}

