/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.asic.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.util.string.functions.SubString;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.CommonAssetClass;
import iso20022.auth030.asic.CurrencyExchange22__1;
import iso20022.auth030.asic.ExchangeRateBasis1;
import iso20022.auth030.asic.ExchangeRateBasis1Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetCcyDefault.class)
public abstract class GetCcy
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected SubString subString;

    public CurrencyExchange22__1 evaluate(ASICTransactionReport drrReport) {
        CurrencyExchange22__1 ccy;
        CurrencyExchange22__1.CurrencyExchange22__1Builder ccyBuilder = this.doEvaluate(drrReport);
        if (ccyBuilder == null) {
            ccy = null;
        } else {
            ccy = ccyBuilder.build();
            this.objectValidator.validate(CurrencyExchange22__1.class, (RosettaModelObject)ccy);
        }
        return ccy;
    }

    protected abstract CurrencyExchange22__1.CurrencyExchange22__1Builder doEvaluate(ASICTransactionReport var1);

    public static class GetCcyDefault
    extends GetCcy {
        @Override
        protected CurrencyExchange22__1.CurrencyExchange22__1Builder doEvaluate(ASICTransactionReport drrReport) {
            CurrencyExchange22__1.CurrencyExchange22__1Builder ccy = CurrencyExchange22__1.builder();
            return this.assignOutput(ccy, drrReport);
        }

        protected CurrencyExchange22__1.CurrencyExchange22__1Builder assignOutput(CurrencyExchange22__1.CurrencyExchange22__1Builder ccy, ASICTransactionReport drrReport) {
            String ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", aSICTransactionReport -> aSICTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getExchangeRateBasis", aSICTransactionReport -> aSICTransactionReport.getExchangeRateBasis()).get(), 1, 3);
            }
            String ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", aSICTransactionReport -> aSICTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CURR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getExchangeRateBasis", aSICTransactionReport -> aSICTransactionReport.getExchangeRateBasis()).get(), 5, 3);
            }
            ccy = (CurrencyExchange22__1.CurrencyExchange22__1Builder)this.toBuilder((RosettaModelObject)CurrencyExchange22__1.builder().setXchgRate((BigDecimal)MapperS.of((Object)drrReport).map("getExchangeRate", aSICTransactionReport -> aSICTransactionReport.getExchangeRate()).get()).setXchgRateBsis(ExchangeRateBasis1Choice__1.builder().setCcyPair(ExchangeRateBasis1.builder().setBaseCcy(ifThenElseResult0).setQtdCcy(ifThenElseResult1).build()).build()).build());
            return Optional.ofNullable(ccy).map(o -> o.prune()).orElse(null);
        }
    }
}

