/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.hkma.rewrite.trade.tr.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import iso20022.auth030.hkma.tr.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.hkma.tr.AmountAndDirection106__2;
import iso20022.auth030.hkma.tr.NotionalAmount5__1;
import iso20022.auth030.hkma.tr.NotionalAmount6__1;
import iso20022.auth030.hkma.tr.NotionalAmountLegs5__1;
import iso20022.auth030.hkma.tr.Schedule11__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetNtnlAmtDefault.class)
public abstract class GetNtnlAmt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;

    public NotionalAmountLegs5__1 evaluate(HKMATransactionReport drrReport) {
        NotionalAmountLegs5__1 ntnlAmt;
        NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmtBuilder = this.doEvaluate(drrReport);
        if (ntnlAmtBuilder == null) {
            ntnlAmt = null;
        } else {
            ntnlAmt = ntnlAmtBuilder.build();
            this.objectValidator.validate(NotionalAmountLegs5__1.class, (RosettaModelObject)ntnlAmt);
        }
        return ntnlAmt;
    }

    protected abstract NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(HKMATransactionReport var1);

    public static class GetNtnlAmtDefault
    extends GetNtnlAmt {
        @Override
        protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder doEvaluate(HKMATransactionReport drrReport) {
            NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt = NotionalAmountLegs5__1.builder();
            return this.assignOutput(ntnlAmt, drrReport);
        }

        protected NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder assignOutput(NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder ntnlAmt, HKMATransactionReport drrReport) {
            Boolean ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getLeg1", hKMATransactionReport -> hKMATransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = false;
            }
            Boolean ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)drrReport).map("getLeg2", hKMATransactionReport -> hKMATransactionReport.getLeg2()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = false;
            }
            ntnlAmt = (NotionalAmountLegs5__1.NotionalAmountLegs5__1Builder)this.toBuilder((RosettaModelObject)NotionalAmountLegs5__1.builder().setFrstLeg(NotionalAmount5__1.builder().setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getLeg1", hKMATransactionReport -> hKMATransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getLeg1", hKMATransactionReport -> hKMATransactionReport.getLeg1()).map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult0).build()).setSchdlPrd(MapperS.of((Object)drrReport).map("getLeg1", hKMATransactionReport -> hKMATransactionReport.getLeg1()).mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).mapItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getValue", notionalPeriod -> notionalPeriod.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)Schedule11__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", notionalPeriod -> notionalPeriod.getEndDate()).get()).setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getValue", notionalPeriod -> notionalPeriod.getValue()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getLeg1", hKMATransactionReport -> hKMATransactionReport.getLeg1()).map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).build());
            }).getMulti()).build()).setScndLeg(NotionalAmount6__1.builder().setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)MapperS.of((Object)drrReport).map("getLeg2", hKMATransactionReport -> hKMATransactionReport.getLeg2()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getLeg2", hKMATransactionReport -> hKMATransactionReport.getLeg2()).map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult1).build()).setSchdlPrd(MapperS.of((Object)drrReport).map("getLeg2", hKMATransactionReport -> hKMATransactionReport.getLeg2()).mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).mapItem(item -> {
                Boolean ifThenElseResult = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getValue", notionalPeriod -> notionalPeriod.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = false;
                }
                return MapperS.of((Object)Schedule11__1.builder().setUadjstdFctvDt((Date)item.map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).get()).setUadjstdEndDt((Date)item.map("getEndDate", notionalPeriod -> notionalPeriod.getEndDate()).get()).setAmt(AmountAndDirection106__2.builder().setAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getValue", notionalPeriod -> notionalPeriod.getValue()).get())).setCcy((String)MapperS.of((Object)drrReport).map("getLeg2", hKMATransactionReport -> hKMATransactionReport.getLeg2()).map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setSgn(ifThenElseResult).build()).build());
            }).getMulti()).build()).build());
            return Optional.ofNullable(ntnlAmt).map(o -> o.prune()).orElse(null);
        }
    }
}

