/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutForQuantityLeg2Rule;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalCurrencyRule;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrencyLeg2RuleDefault.class)
public abstract class NotionalCurrencyLeg2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected NotionalCurrencyRule notionalCurrencyRule;
    @Inject
    protected PayoutForQuantityLeg2Rule payoutForQuantityLeg2Rule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrencyLeg2RuleDefault
    extends NotionalCurrencyLeg2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEventBase)item.get()));
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)this.notionalCurrencyRule.evaluate(this.payoutForQuantityLeg2Rule.evaluate((TransactionReportInstruction)thenArg.get()))).get();
            return output;
        }
    }
}

