/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ASICTransactionReportDTCC_ASIC_BR_1020_01b")
@ImplementedBy(value=Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1020_01b
extends Validator<ASICTransactionReport> {
    public static final String NAME = "ASICTransactionReportDTCC_ASIC_BR_1020_01b";
    public static final String DEFINITION = "if [ActionTypeEnum -> TERM, ActionTypeEnum -> PRTO, ActionTypeEnum -> EROR] any = actionType then if ActionTypeEnum -> TERM = actionType then (eventTimestamp -> date >= executionTimestamp -> date and eventTimestamp -> date <= reportingTimestamp -> date) else if [ActionTypeEnum -> PRTO, ActionTypeEnum -> EROR] any = actionType then eventTimestamp -> date <= reportingTimestamp -> date";

    public static class NoOp
    implements ASICTransactionReportDTCC_ASIC_BR_1020_01b {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ASICTransactionReportDTCC_ASIC_BR_1020_01b {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            ComparisonResult result = this.executeDataRule(aSICTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ASICTransactionReportDTCC_ASIC_BR_1020_01b.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1020_01b.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ASICTransactionReportDTCC_ASIC_BR_1020_01b.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1020_01b.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.TERM)), MapperS.of((Object)((Object)ActionTypeEnum.PRTO)), MapperS.of((Object)((Object)ActionTypeEnum.EROR))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)ActionTypeEnum.TERM)), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)aSICTransactionReport).map("getEventTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getEventTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getExecutionTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getExecutionTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)aSICTransactionReport).map("getEventTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getEventTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getReportingTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getReportingTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All));
                    }
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.PRTO)), MapperS.of((Object)((Object)ActionTypeEnum.EROR))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)aSICTransactionReport).map("getEventTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getEventTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getReportingTimestamp", _aSICTransactionReport -> _aSICTransactionReport.getReportingTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

