/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version2.party.functions.PayerParty;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PayerPartyLeg1Default.class)
public abstract class PayerPartyLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CounterpartiesForEvent counterpartiesForEvent;
    @Inject
    protected PayerParty payerParty;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;

    public Party evaluate(TransactionReportInstruction transaction) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(transaction);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PayerPartyLeg1Default
    extends PayerPartyLeg1 {
        @Override
        protected Party.PartyBuilder doEvaluate(TransactionReportInstruction transaction) {
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, transaction);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, TransactionReportInstruction transaction) {
            party = (Party.PartyBuilder)this.toBuilder((RosettaModelObject)this.payerParty.evaluate(this.payoutLeg1Rule.evaluate(transaction), this.counterpartiesForEvent.evaluate(transaction)));
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }
    }
}

