/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.PartyRoleEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.util.party.functions.ExtractPartyFromRelatedPartyByRole;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

@ImplementedBy(value=PrimeBrokerageTransactionIndicatorFuncDefault.class)
public abstract class PrimeBrokerageTransactionIndicatorFunc
implements RosettaFunction {
    @Inject
    protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;

    public Boolean evaluate(TransactionReportInstruction transaction) {
        Boolean indicator = this.doEvaluate(transaction);
        return indicator;
    }

    protected abstract Boolean doEvaluate(TransactionReportInstruction var1);

    protected abstract MapperS<Boolean> primeBrokerExists(TransactionReportInstruction var1);

    protected abstract MapperC<? extends RegimePartyInformation> executingBrokerPartyInfo(TransactionReportInstruction var1);

    protected abstract MapperS<Boolean> executingBrokerIsUSPerson(TransactionReportInstruction var1);

    public static class PrimeBrokerageTransactionIndicatorFuncDefault
    extends PrimeBrokerageTransactionIndicatorFunc {
        @Override
        protected Boolean doEvaluate(TransactionReportInstruction transaction) {
            Boolean indicator = null;
            return this.assignOutput(indicator, transaction);
        }

        protected Boolean assignOutput(Boolean indicator, TransactionReportInstruction transaction) {
            indicator = ComparisonResult.ofNullSafe(this.primeBrokerExists(transaction)).andNullSafe(ComparisonResult.ofNullSafe(this.executingBrokerIsUSPerson(transaction))).get();
            return indicator;
        }

        @Override
        protected MapperS<Boolean> primeBrokerExists(TransactionReportInstruction transaction) {
            return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.extractPartyFromRelatedPartyByRole.evaluate(MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.PRIME_BROKER))).asMapper();
        }

        @Override
        protected MapperC<? extends RegimePartyInformation> executingBrokerPartyInfo(TransactionReportInstruction transaction) {
            return MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getRegimePartyInformation", reportableInformation -> reportableInformation.getRegimePartyInformation()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getPartyReference", regimePartyInformation -> regimePartyInformation.getPartyReference()).map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()), (Mapper)MapperS.of((Object)this.extractPartyFromRelatedPartyByRole.evaluate(MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.EXECUTING_BROKER)), (CardinalityOperator)CardinalityOperator.All).get());
        }

        @Override
        protected MapperS<Boolean> executingBrokerIsUSPerson(TransactionReportInstruction transaction) {
            return MapperS.of((Object)((Boolean)this.executingBrokerPartyInfo(transaction).mapC("getRegimeInformation", regimePartyInformation -> regimePartyInformation.getRegimeInformation()).map("getCftcPartyInformation", reportingRegime -> reportingRegime.getCftcPartyInformation()).map("getIsUSPerson", cFTCPartyInformation -> cFTCPartyInformation.getIsUSPerson()).first().getOrDefault((Object)false)));
        }
    }
}

