/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.cftc.rewrite.margin.meta.CFTCMarginReportMeta;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.margin.CommonMarginReport;
import drr.standards.iso.CollateralisationType3Code;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CFTCMarginReport", builder=CFTCMarginReportBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="CFTCMarginReport", model="drr", builder=CFTCMarginReportBuilderImpl.class, version="7.0.0-dev.92")
public interface CFTCMarginReport
extends CommonMarginReport {
    public static final CFTCMarginReportMeta metaData = new CFTCMarginReportMeta();

    @Override
    public String getCounterparty2();

    @Override
    public MarginActionEnum getActionType();

    @Override
    public ZonedDateTime getEventTimestamp();

    public String getCounterparty2IdentifierSource();

    public String getUniqueSwapIdentifier();

    public Boolean getAffiliatedCounterpartyForMarginAndCapitalIndicator();

    public Boolean getPortfolioContainingNonReportableComponentIndicator();

    public PartyIdentifierTypeEnum getTradeParty1IDType();

    public PartyIdentifierTypeEnum getSubmittingPartyIDType();

    public String getUsiIDPrefix();

    public String getUtiIDPrefix();

    public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination();

    public String getComment1();

    public String getMessageID();

    public String getMessageType();

    public String getVersion();

    @Override
    public CFTCMarginReport build();

    @Override
    public CFTCMarginReportBuilder toBuilder();

    public static CFTCMarginReportBuilder builder() {
        return new CFTCMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CFTCMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CFTCMarginReport> getType() {
        return CFTCMarginReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("affiliatedCounterpartyForMarginAndCapitalIndicator"), Boolean.class, (Object)this.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportableComponentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CFTCMarginReportBuilderImpl
    extends CommonMarginReport.CommonMarginReportBuilderImpl
    implements CFTCMarginReportBuilder {
        protected String counterparty2;
        protected MarginActionEnum actionType;
        protected ZonedDateTime eventTimestamp;
        protected String counterparty2IdentifierSource;
        protected String uniqueSwapIdentifier;
        protected Boolean affiliatedCounterpartyForMarginAndCapitalIndicator;
        protected Boolean portfolioContainingNonReportableComponentIndicator;
        protected PartyIdentifierTypeEnum tradeParty1IDType;
        protected PartyIdentifierTypeEnum submittingPartyIDType;
        protected String usiIDPrefix;
        protected String utiIDPrefix;
        protected List<SupervisoryBodyEnum> tradeParty1ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected String comment1;
        protected String messageID;
        protected String messageType;
        protected String version;

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueSwapIdentifier", isRequired=true)
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        @RuneAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        public Boolean getAffiliatedCounterpartyForMarginAndCapitalIndicator() {
            return this.affiliatedCounterpartyForMarginAndCapitalIndicator;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public Boolean getPortfolioContainingNonReportableComponentIndicator() {
            return this.portfolioContainingNonReportableComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public String getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CFTCMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CFTCMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public CFTCMarginReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public CFTCMarginReportBuilder setCounterparty2OverriddenAsString(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCMarginReportBuilder setCounterparty2(String _counterparty2) {
            return this.setCounterparty2OverriddenAsString(_counterparty2);
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public CFTCMarginReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public CFTCMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public CFTCMarginReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CFTCMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        public CFTCMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PreHaircut) {
            this.initialMarginPostedByTheCounterparty1PreHaircut = _initialMarginPostedByTheCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        public CFTCMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PostHaircut) {
            this.initialMarginPostedByTheCounterparty1PostHaircut = _initialMarginPostedByTheCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginPostedByCounterparty1Currency")
        public CFTCMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
            this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        public CFTCMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PreHaircut) {
            this.variationMarginPostedByTheCounterparty1PreHaircut = _variationMarginPostedByTheCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        public CFTCMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PostHaircut) {
            this.variationMarginPostedByTheCounterparty1PostHaircut = _variationMarginPostedByTheCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginPostedByCounterparty1Currency")
        public CFTCMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
            this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        public CFTCMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
            this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        public CFTCMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
            this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1Currency")
        public CFTCMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
            this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        public CFTCMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PreHaircut) {
            this.variationMarginCollectedByTheCounterparty1PreHaircut = _variationMarginCollectedByTheCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        public CFTCMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PostHaircut) {
            this.variationMarginCollectedByTheCounterparty1PostHaircut = _variationMarginCollectedByTheCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginCollectedByCounterparty1Currency")
        public CFTCMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
            this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralPostedByTheCounterparty1")
        public CFTCMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
            this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public CFTCMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
            this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralCollectedByTheCounterparty1")
        public CFTCMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
            this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public CFTCMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
            this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public CFTCMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public CFTCMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public CFTCMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public CFTCMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CFTCMarginReportBuilder setActionTypeOverriddenAsMarginActionEnum(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            return this.setActionTypeOverriddenAsMarginActionEnum(_actionType);
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public CFTCMarginReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public CFTCMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public CFTCMarginReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueSwapIdentifier", isRequired=true)
        public CFTCMarginReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
            this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        @RuneAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        public CFTCMarginReportBuilder setAffiliatedCounterpartyForMarginAndCapitalIndicator(Boolean _affiliatedCounterpartyForMarginAndCapitalIndicator) {
            this.affiliatedCounterpartyForMarginAndCapitalIndicator = _affiliatedCounterpartyForMarginAndCapitalIndicator == null ? null : _affiliatedCounterpartyForMarginAndCapitalIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public CFTCMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean _portfolioContainingNonReportableComponentIndicator) {
            this.portfolioContainingNonReportableComponentIndicator = _portfolioContainingNonReportableComponentIndicator == null ? null : _portfolioContainingNonReportableComponentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public CFTCMarginReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum _tradeParty1IDType) {
            this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public CFTCMarginReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
            this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public CFTCMarginReportBuilder setUsiIDPrefix(String _usiIDPrefix) {
            this.usiIDPrefix = _usiIDPrefix == null ? null : _usiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public CFTCMarginReportBuilder setUtiIDPrefix(String _utiIDPrefix) {
            this.utiIDPrefix = _utiIDPrefix == null ? null : _utiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
            if (_tradeParty1ReportingDestination != null) {
                this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
            }
            return this;
        }

        @Override
        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
            this.getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
            return this;
        }

        @Override
        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            if (tradeParty1ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
                    this.tradeParty1ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public CFTCMarginReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty1ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public CFTCMarginReportBuilder setComment1(String _comment1) {
            this.comment1 = _comment1 == null ? null : _comment1;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public CFTCMarginReportBuilder setMessageID(String _messageID) {
            this.messageID = _messageID == null ? null : _messageID;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public CFTCMarginReportBuilder setMessageType(String _messageType) {
            this.messageType = _messageType == null ? null : _messageType;
            return this;
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public CFTCMarginReportBuilder setVersion(String _version) {
            this.version = _version == null ? null : _version;
            return this;
        }

        @Override
        public CFTCMarginReport build() {
            return new CFTCMarginReportImpl(this);
        }

        @Override
        public CFTCMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CFTCMarginReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierSource() != null) {
                return true;
            }
            if (this.getUniqueSwapIdentifier() != null) {
                return true;
            }
            if (this.getAffiliatedCounterpartyForMarginAndCapitalIndicator() != null) {
                return true;
            }
            if (this.getPortfolioContainingNonReportableComponentIndicator() != null) {
                return true;
            }
            if (this.getTradeParty1IDType() != null) {
                return true;
            }
            if (this.getSubmittingPartyIDType() != null) {
                return true;
            }
            if (this.getUsiIDPrefix() != null) {
                return true;
            }
            if (this.getUtiIDPrefix() != null) {
                return true;
            }
            if (this.getTradeParty1ReportingDestination() != null && !this.getTradeParty1ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getComment1() != null) {
                return true;
            }
            if (this.getMessageID() != null) {
                return true;
            }
            if (this.getMessageType() != null) {
                return true;
            }
            return this.getVersion() != null;
        }

        @Override
        public CFTCMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CFTCMarginReportBuilder o = (CFTCMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2OverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionTypeOverriddenAsMarginActionEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierSource(), (Object)o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueSwapIdentifier(), (Object)o.getUniqueSwapIdentifier(), this::setUniqueSwapIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), (Object)o.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), this::setAffiliatedCounterpartyForMarginAndCapitalIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPortfolioContainingNonReportableComponentIndicator(), (Object)o.getPortfolioContainingNonReportableComponentIndicator(), this::setPortfolioContainingNonReportableComponentIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1IDType(), (Object)o.getTradeParty1IDType(), this::setTradeParty1IDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittingPartyIDType(), (Object)o.getSubmittingPartyIDType(), this::setSubmittingPartyIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUsiIDPrefix(), (Object)o.getUsiIDPrefix(), this::setUsiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUtiIDPrefix(), (Object)o.getUtiIDPrefix(), this::setUtiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic(this.getTradeParty1ReportingDestination(), o.getTradeParty1ReportingDestination(), this::addTradeParty1ReportingDestination);
            merger.mergeBasic((Object)this.getComment1(), (Object)o.getComment1(), this::setComment1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageID(), (Object)o.getMessageID(), this::setMessageID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageType(), (Object)o.getMessageType(), this::setMessageType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CFTCMarginReport _that = (CFTCMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.affiliatedCounterpartyForMarginAndCapitalIndicator, _that.getAffiliatedCounterpartyForMarginAndCapitalIndicator())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.affiliatedCounterpartyForMarginAndCapitalIndicator != null ? this.affiliatedCounterpartyForMarginAndCapitalIndicator.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportableComponentIndicator != null ? this.portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CFTCMarginReportBuilder {counterparty2=" + this.counterparty2 + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", affiliatedCounterpartyForMarginAndCapitalIndicator=" + this.affiliatedCounterpartyForMarginAndCapitalIndicator + ", portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", version=" + this.version + "} " + super.toString();
        }
    }

    public static interface CFTCMarginReportBuilder
    extends CFTCMarginReport,
    CommonMarginReport.CommonMarginReportBuilder {
        @Override
        public CFTCMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public CFTCMarginReportBuilder setCounterparty1(String var1);

        @Override
        public CFTCMarginReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public CFTCMarginReportBuilder setCounterparty2(String var1);

        @Override
        public CFTCMarginReportBuilder setCollateralPortfolioCode(String var1);

        @Override
        public CFTCMarginReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public CFTCMarginReportBuilder setUti(String var1);

        @Override
        public CFTCMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code var1);

        @Override
        public CFTCMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String var1);

        @Override
        public CFTCMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal var1);

        @Override
        public CFTCMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String var1);

        @Override
        public CFTCMarginReportBuilder setCollateralTimestamp(ZonedDateTime var1);

        @Override
        public CFTCMarginReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public CFTCMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public CFTCMarginReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public CFTCMarginReportBuilder setActionType(MarginActionEnum var1);

        @Override
        public CFTCMarginReportBuilder setEventDate(Date var1);

        @Override
        public CFTCMarginReportBuilder setEventTimestamp(ZonedDateTime var1);

        public CFTCMarginReportBuilder setCounterparty2OverriddenAsString(String var1);

        public CFTCMarginReportBuilder setActionTypeOverriddenAsMarginActionEnum(MarginActionEnum var1);

        public CFTCMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public CFTCMarginReportBuilder setCounterparty2IdentifierSource(String var1);

        public CFTCMarginReportBuilder setUniqueSwapIdentifier(String var1);

        public CFTCMarginReportBuilder setAffiliatedCounterpartyForMarginAndCapitalIndicator(Boolean var1);

        public CFTCMarginReportBuilder setPortfolioContainingNonReportableComponentIndicator(Boolean var1);

        public CFTCMarginReportBuilder setTradeParty1IDType(PartyIdentifierTypeEnum var1);

        public CFTCMarginReportBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum var1);

        public CFTCMarginReportBuilder setUsiIDPrefix(String var1);

        public CFTCMarginReportBuilder setUtiIDPrefix(String var1);

        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1);

        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public CFTCMarginReportBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCMarginReportBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public CFTCMarginReportBuilder setComment1(String var1);

        public CFTCMarginReportBuilder setMessageID(String var1);

        public CFTCMarginReportBuilder setMessageType(String var1);

        public CFTCMarginReportBuilder setVersion(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("affiliatedCounterpartyForMarginAndCapitalIndicator"), Boolean.class, (Object)this.getAffiliatedCounterpartyForMarginAndCapitalIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("portfolioContainingNonReportableComponentIndicator"), Boolean.class, (Object)this.getPortfolioContainingNonReportableComponentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CFTCMarginReportBuilder prune();
    }

    public static class CFTCMarginReportImpl
    extends CommonMarginReport.CommonMarginReportImpl
    implements CFTCMarginReport {
        private final String counterparty2;
        private final MarginActionEnum actionType;
        private final ZonedDateTime eventTimestamp;
        private final String counterparty2IdentifierSource;
        private final String uniqueSwapIdentifier;
        private final Boolean affiliatedCounterpartyForMarginAndCapitalIndicator;
        private final Boolean portfolioContainingNonReportableComponentIndicator;
        private final PartyIdentifierTypeEnum tradeParty1IDType;
        private final PartyIdentifierTypeEnum submittingPartyIDType;
        private final String usiIDPrefix;
        private final String utiIDPrefix;
        private final List<SupervisoryBodyEnum> tradeParty1ReportingDestination;
        private final String comment1;
        private final String messageID;
        private final String messageType;
        private final String version;

        protected CFTCMarginReportImpl(CFTCMarginReportBuilder builder) {
            super(builder);
            this.counterparty2 = builder.getCounterparty2();
            this.actionType = builder.getActionType();
            this.eventTimestamp = builder.getEventTimestamp();
            this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
            this.uniqueSwapIdentifier = builder.getUniqueSwapIdentifier();
            this.affiliatedCounterpartyForMarginAndCapitalIndicator = builder.getAffiliatedCounterpartyForMarginAndCapitalIndicator();
            this.portfolioContainingNonReportableComponentIndicator = builder.getPortfolioContainingNonReportableComponentIndicator();
            this.tradeParty1IDType = builder.getTradeParty1IDType();
            this.submittingPartyIDType = builder.getSubmittingPartyIDType();
            this.usiIDPrefix = builder.getUsiIDPrefix();
            this.utiIDPrefix = builder.getUtiIDPrefix();
            this.tradeParty1ReportingDestination = Optional.ofNullable(builder.getTradeParty1ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.comment1 = builder.getComment1();
            this.messageID = builder.getMessageID();
            this.messageType = builder.getMessageType();
            this.version = builder.getVersion();
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueSwapIdentifier", isRequired=true)
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        @RuneAttribute(value="affiliatedCounterpartyForMarginAndCapitalIndicator", isRequired=true)
        public Boolean getAffiliatedCounterpartyForMarginAndCapitalIndicator() {
            return this.affiliatedCounterpartyForMarginAndCapitalIndicator;
        }

        @Override
        @RosettaAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        @RuneAttribute(value="portfolioContainingNonReportableComponentIndicator", isRequired=true)
        public Boolean getPortfolioContainingNonReportableComponentIndicator() {
            return this.portfolioContainingNonReportableComponentIndicator;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType", isRequired=true)
        @RuneAttribute(value="tradeParty1IDType", isRequired=true)
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType", isRequired=true)
        @RuneAttribute(value="submittingPartyIDType", isRequired=true)
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        @RuneAttribute(value="tradeParty1ReportingDestination", isRequired=true)
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="comment1", isRequired=true)
        @RuneAttribute(value="comment1", isRequired=true)
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID", isRequired=true)
        @RuneAttribute(value="messageID", isRequired=true)
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType", isRequired=true)
        @RuneAttribute(value="messageType", isRequired=true)
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="version", isRequired=true)
        @RuneAttribute(value="version", isRequired=true)
        public String getVersion() {
            return this.version;
        }

        @Override
        public CFTCMarginReport build() {
            return this;
        }

        @Override
        public CFTCMarginReportBuilder toBuilder() {
            CFTCMarginReportBuilder builder = CFTCMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CFTCMarginReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2OverriddenAsString);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionTypeOverriddenAsMarginActionEnum);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
            Optional.ofNullable(this.getUniqueSwapIdentifier()).ifPresent(builder::setUniqueSwapIdentifier);
            Optional.ofNullable(this.getAffiliatedCounterpartyForMarginAndCapitalIndicator()).ifPresent(builder::setAffiliatedCounterpartyForMarginAndCapitalIndicator);
            Optional.ofNullable(this.getPortfolioContainingNonReportableComponentIndicator()).ifPresent(builder::setPortfolioContainingNonReportableComponentIndicator);
            Optional.ofNullable(this.getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
            Optional.ofNullable(this.getSubmittingPartyIDType()).ifPresent(builder::setSubmittingPartyIDType);
            Optional.ofNullable(this.getUsiIDPrefix()).ifPresent(builder::setUsiIDPrefix);
            Optional.ofNullable(this.getUtiIDPrefix()).ifPresent(builder::setUtiIDPrefix);
            Optional.ofNullable(this.getTradeParty1ReportingDestination()).ifPresent(builder::setTradeParty1ReportingDestination);
            Optional.ofNullable(this.getComment1()).ifPresent(builder::setComment1);
            Optional.ofNullable(this.getMessageID()).ifPresent(builder::setMessageID);
            Optional.ofNullable(this.getMessageType()).ifPresent(builder::setMessageType);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CFTCMarginReport _that = (CFTCMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.affiliatedCounterpartyForMarginAndCapitalIndicator, _that.getAffiliatedCounterpartyForMarginAndCapitalIndicator())) {
                return false;
            }
            if (!Objects.equals(this.portfolioContainingNonReportableComponentIndicator, _that.getPortfolioContainingNonReportableComponentIndicator())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.affiliatedCounterpartyForMarginAndCapitalIndicator != null ? this.affiliatedCounterpartyForMarginAndCapitalIndicator.hashCode() : 0);
            _result = 31 * _result + (this.portfolioContainingNonReportableComponentIndicator != null ? this.portfolioContainingNonReportableComponentIndicator.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CFTCMarginReport {counterparty2=" + this.counterparty2 + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", affiliatedCounterpartyForMarginAndCapitalIndicator=" + this.affiliatedCounterpartyForMarginAndCapitalIndicator + ", portfolioContainingNonReportableComponentIndicator=" + this.portfolioContainingNonReportableComponentIndicator + ", tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", version=" + this.version + "} " + super.toString();
        }
    }
}

