/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.uti.functions.GetUniqueTransactionIdentifier;
import drr.standards.iso.functions.IsMax52UpperCaseAlphanumericTextWithSpecialChars;
import java.util.Collections;
import javax.inject.Inject;

@ImplementedBy(value=UniqueTransactionIdentifierRuleDefault.class)
public abstract class UniqueTransactionIdentifierRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected GetUniqueTransactionIdentifier getUniqueTransactionIdentifier;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected IsMax52UpperCaseAlphanumericTextWithSpecialChars isMax52UpperCaseAlphanumericTextWithSpecialChars;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UniqueTransactionIdentifierRuleDefault
    extends UniqueTransactionIdentifierRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEventBase)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                SupervisoryBodyEnum supervisoryBodyEnum = SupervisoryBodyEnum.CFTC;
                return MapperS.of((Object)this.getUniqueTransactionIdentifier.evaluate((ReportableInformation)item.map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get(), supervisoryBodyEnum == null ? Collections.emptyList() : Collections.singletonList(supervisoryBodyEnum), null, (TransactionReportInstruction)item.get()));
            });
            output = (String)thenArg1.filterSingleNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isMax52UpperCaseAlphanumericTextWithSpecialChars.evaluate((String)item.get())), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).get()).get();
            return output;
        }
    }
}

