/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.cftc.rewrite.dtcc.valuation.DTCCAdditionalValuationFields;
import drr.regulation.cftc.rewrite.valuation.meta.CFTCValuationReportMeta;
import drr.regulation.common.valuation.CommonValuationReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CFTCValuationReport", builder=CFTCValuationReportBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="CFTCValuationReport", model="drr", builder=CFTCValuationReportBuilderImpl.class, version="7.0.0-dev.92")
public interface CFTCValuationReport
extends CommonValuationReport {
    public static final CFTCValuationReportMeta metaData = new CFTCValuationReportMeta();

    @Override
    public String getCounterparty2IdentifierSource();

    @Override
    public String getReportSubmittingEntityID();

    @Override
    public String getInitialMarginCollateralPortfolioCode();

    @Override
    public String getVariationMarginCollateralPortfolioCode();

    public DTCCAdditionalValuationFields getDtccValuationFields();

    public String getUniqueProductIdentifier();

    public String getUniqueSwapIdentifier();

    @Override
    public CFTCValuationReport build();

    @Override
    public CFTCValuationReportBuilder toBuilder();

    public static CFTCValuationReportBuilder builder() {
        return new CFTCValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CFTCValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CFTCValuationReport> getType() {
        return CFTCValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dtccValuationFields"), processor, DTCCAdditionalValuationFields.class, this.getDtccValuationFields(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CFTCValuationReportBuilderImpl
    extends CommonValuationReport.CommonValuationReportBuilderImpl
    implements CFTCValuationReportBuilder {
        protected String counterparty2IdentifierSource;
        protected String reportSubmittingEntityID;
        protected String initialMarginCollateralPortfolioCode;
        protected String variationMarginCollateralPortfolioCode;
        protected DTCCAdditionalValuationFields.DTCCAdditionalValuationFieldsBuilder dtccValuationFields;
        protected String uniqueProductIdentifier;
        protected String uniqueSwapIdentifier;

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="dtccValuationFields")
        @RuneAttribute(value="dtccValuationFields")
        public DTCCAdditionalValuationFields.DTCCAdditionalValuationFieldsBuilder getDtccValuationFields() {
            return this.dtccValuationFields;
        }

        @Override
        public DTCCAdditionalValuationFields.DTCCAdditionalValuationFieldsBuilder getOrCreateDtccValuationFields() {
            DTCCAdditionalValuationFields.DTCCAdditionalValuationFieldsBuilder result = this.dtccValuationFields != null ? this.dtccValuationFields : (this.dtccValuationFields = DTCCAdditionalValuationFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueProductIdentifier", isRequired=true)
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CFTCValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CFTCValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public CFTCValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public CFTCValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public CFTCValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public CFTCValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public CFTCValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public CFTCValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public CFTCValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CFTCValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public CFTCValuationReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public CFTCValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public CFTCValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            return this.setReportSubmittingEntityIDOverriddenAsString(_reportSubmittingEntityID);
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public CFTCValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public CFTCValuationReportBuilder setCounterparty2IdentifierSourceOverriddenAsString(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCValuationReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            return this.setCounterparty2IdentifierSourceOverriddenAsString(_counterparty2IdentifierSource);
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public CFTCValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public CFTCValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public CFTCValuationReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public CFTCValuationReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCValuationReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            return this.setVariationMarginCollateralPortfolioCodeOverriddenAsString(_variationMarginCollateralPortfolioCode);
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        public CFTCValuationReportBuilder setInitialMarginCollateralPortfolioCodeOverriddenAsString(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CFTCValuationReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            return this.setInitialMarginCollateralPortfolioCodeOverriddenAsString(_initialMarginCollateralPortfolioCode);
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal _lastFloatingReferenceValueLeg1) {
            this.lastFloatingReferenceValueLeg1 = _lastFloatingReferenceValueLeg1 == null ? null : _lastFloatingReferenceValueLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal _lastFloatingReferenceValueLeg2) {
            this.lastFloatingReferenceValueLeg2 = _lastFloatingReferenceValueLeg2 == null ? null : _lastFloatingReferenceValueLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date _lastFloatingReferenceResetDateLeg1) {
            this.lastFloatingReferenceResetDateLeg1 = _lastFloatingReferenceResetDateLeg1 == null ? null : _lastFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date _lastFloatingReferenceResetDateLeg2) {
            this.lastFloatingReferenceResetDateLeg2 = _lastFloatingReferenceResetDateLeg2 == null ? null : _lastFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="dtccValuationFields")
        @RuneAttribute(value="dtccValuationFields")
        public CFTCValuationReportBuilder setDtccValuationFields(DTCCAdditionalValuationFields _dtccValuationFields) {
            this.dtccValuationFields = _dtccValuationFields == null ? null : _dtccValuationFields.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueProductIdentifier", isRequired=true)
        public CFTCValuationReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public CFTCValuationReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
            this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
            return this;
        }

        @Override
        public CFTCValuationReport build() {
            return new CFTCValuationReportImpl(this);
        }

        @Override
        public CFTCValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CFTCValuationReportBuilder prune() {
            super.prune();
            if (this.dtccValuationFields != null && !this.dtccValuationFields.prune().hasData()) {
                this.dtccValuationFields = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2IdentifierSource() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getDtccValuationFields() != null && this.getDtccValuationFields().hasData()) {
                return true;
            }
            if (this.getUniqueProductIdentifier() != null) {
                return true;
            }
            return this.getUniqueSwapIdentifier() != null;
        }

        @Override
        public CFTCValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CFTCValuationReportBuilder o = (CFTCValuationReportBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDtccValuationFields(), (RosettaModelObjectBuilder)o.getDtccValuationFields(), this::setDtccValuationFields);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierSource(), (Object)o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSourceOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityIDOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCodeOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCodeOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueProductIdentifier(), (Object)o.getUniqueProductIdentifier(), this::setUniqueProductIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueSwapIdentifier(), (Object)o.getUniqueSwapIdentifier(), this::setUniqueSwapIdentifier, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CFTCValuationReport _that = (CFTCValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.dtccValuationFields, _that.getDtccValuationFields())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            return Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.dtccValuationFields != null ? this.dtccValuationFields.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CFTCValuationReportBuilder {counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", dtccValuationFields=" + String.valueOf(this.dtccValuationFields) + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + "} " + super.toString();
        }
    }

    public static interface CFTCValuationReportBuilder
    extends CFTCValuationReport,
    CommonValuationReport.CommonValuationReportBuilder {
        public DTCCAdditionalValuationFields.DTCCAdditionalValuationFieldsBuilder getOrCreateDtccValuationFields();

        @Override
        public DTCCAdditionalValuationFields.DTCCAdditionalValuationFieldsBuilder getDtccValuationFields();

        @Override
        public CFTCValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public CFTCValuationReportBuilder setCounterparty1(String var1);

        @Override
        public CFTCValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public CFTCValuationReportBuilder setCounterparty2(String var1);

        @Override
        public CFTCValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public CFTCValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CFTCValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public CFTCValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public CFTCValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public CFTCValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public CFTCValuationReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public CFTCValuationReportBuilder setTechnicalRecordId(String var1);

        @Override
        public CFTCValuationReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public CFTCValuationReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public CFTCValuationReportBuilder setCounterparty2IdentifierSource(String var1);

        @Override
        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public CFTCValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        @Override
        public CFTCValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public CFTCValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public CFTCValuationReportBuilder setEventDate(Date var1);

        @Override
        public CFTCValuationReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public CFTCValuationReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal var1);

        @Override
        public CFTCValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal var1);

        @Override
        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public CFTCValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date var1);

        public CFTCValuationReportBuilder setCounterparty2IdentifierSourceOverriddenAsString(String var1);

        public CFTCValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String var1);

        public CFTCValuationReportBuilder setInitialMarginCollateralPortfolioCodeOverriddenAsString(String var1);

        public CFTCValuationReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String var1);

        public CFTCValuationReportBuilder setDtccValuationFields(DTCCAdditionalValuationFields var1);

        public CFTCValuationReportBuilder setUniqueProductIdentifier(String var1);

        public CFTCValuationReportBuilder setUniqueSwapIdentifier(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dtccValuationFields"), processor, DTCCAdditionalValuationFields.DTCCAdditionalValuationFieldsBuilder.class, this.getDtccValuationFields(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, (Object)this.getUniqueSwapIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CFTCValuationReportBuilder prune();
    }

    public static class CFTCValuationReportImpl
    extends CommonValuationReport.CommonValuationReportImpl
    implements CFTCValuationReport {
        private final String counterparty2IdentifierSource;
        private final String reportSubmittingEntityID;
        private final String initialMarginCollateralPortfolioCode;
        private final String variationMarginCollateralPortfolioCode;
        private final DTCCAdditionalValuationFields dtccValuationFields;
        private final String uniqueProductIdentifier;
        private final String uniqueSwapIdentifier;

        protected CFTCValuationReportImpl(CFTCValuationReportBuilder builder) {
            super(builder);
            this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.dtccValuationFields = Optional.ofNullable(builder.getDtccValuationFields()).map(f -> f.build()).orElse(null);
            this.uniqueProductIdentifier = builder.getUniqueProductIdentifier();
            this.uniqueSwapIdentifier = builder.getUniqueSwapIdentifier();
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierSource", isRequired=true)
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="initialMarginCollateralPortfolioCode", isRequired=true)
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="dtccValuationFields")
        @RuneAttribute(value="dtccValuationFields")
        public DTCCAdditionalValuationFields getDtccValuationFields() {
            return this.dtccValuationFields;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueProductIdentifier", isRequired=true)
        public String getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueSwapIdentifier")
        @RuneAttribute(value="uniqueSwapIdentifier")
        public String getUniqueSwapIdentifier() {
            return this.uniqueSwapIdentifier;
        }

        @Override
        public CFTCValuationReport build() {
            return this;
        }

        @Override
        public CFTCValuationReportBuilder toBuilder() {
            CFTCValuationReportBuilder builder = CFTCValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CFTCValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSourceOverriddenAsString);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityIDOverriddenAsString);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCodeOverriddenAsString);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCodeOverriddenAsString);
            Optional.ofNullable(this.getDtccValuationFields()).ifPresent(builder::setDtccValuationFields);
            Optional.ofNullable(this.getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
            Optional.ofNullable(this.getUniqueSwapIdentifier()).ifPresent(builder::setUniqueSwapIdentifier);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CFTCValuationReport _that = (CFTCValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.dtccValuationFields, _that.getDtccValuationFields())) {
                return false;
            }
            if (!Objects.equals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            return Objects.equals(this.uniqueSwapIdentifier, _that.getUniqueSwapIdentifier());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.dtccValuationFields != null ? this.dtccValuationFields.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueSwapIdentifier != null ? this.uniqueSwapIdentifier.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CFTCValuationReport {counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", dtccValuationFields=" + String.valueOf(this.dtccValuationFields) + ", uniqueProductIdentifier=" + this.uniqueProductIdentifier + ", uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + "} " + super.toString();
        }
    }
}

