/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.ValuationReportInstruction;
import drr.standards.iosco.uti.functions.UniqueSwapIdentifierForValuation;
import java.util.Collections;
import javax.inject.Inject;

@ImplementedBy(value=UniqueSwapIdentifierRuleDefault.class)
public abstract class UniqueSwapIdentifierRule
implements ReportFunction<ValuationReportInstruction, String> {
    @Inject
    protected UniqueSwapIdentifierForValuation uniqueSwapIdentifierForValuation;

    public String evaluate(ValuationReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(ValuationReportInstruction var1);

    public static class UniqueSwapIdentifierRuleDefault
    extends UniqueSwapIdentifierRule {
        @Override
        protected String doEvaluate(ValuationReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, ValuationReportInstruction input) {
            SupervisoryBodyEnum supervisoryBodyEnum = SupervisoryBodyEnum.CFTC;
            output = this.uniqueSwapIdentifierForValuation.evaluate(input, supervisoryBodyEnum == null ? Collections.emptyList() : Collections.singletonList(supervisoryBodyEnum));
            return output;
        }
    }
}

