/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.meta.RegimePartyInformationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegimePartyInformation", builder=RegimePartyInformationBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="RegimePartyInformation", model="drr", builder=RegimePartyInformationBuilderImpl.class, version="7.0.0-dev.92")
public interface RegimePartyInformation
extends RosettaModelObject {
    public static final RegimePartyInformationMeta metaData = new RegimePartyInformationMeta();

    public ReferenceWithMetaParty getPartyReference();

    public List<? extends ReportingRegime> getRegimeInformation();

    public RegimePartyInformation build();

    public RegimePartyInformationBuilder toBuilder();

    public static RegimePartyInformationBuilder builder() {
        return new RegimePartyInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends RegimePartyInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegimePartyInformation> getType() {
        return RegimePartyInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regimeInformation"), processor, ReportingRegime.class, this.getRegimeInformation(), new AttributeMeta[0]);
    }

    public static class RegimePartyInformationBuilderImpl
    implements RegimePartyInformationBuilder {
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder partyReference;
        protected List<ReportingRegime.ReportingRegimeBuilder> regimeInformation = new ArrayList<ReportingRegime.ReportingRegimeBuilder>();

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference() {
            return this.partyReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.partyReference != null ? this.partyReference : (this.partyReference = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regimeInformation", isRequired=true)
        @RuneAttribute(value="regimeInformation", isRequired=true)
        public List<? extends ReportingRegime.ReportingRegimeBuilder> getRegimeInformation() {
            return this.regimeInformation;
        }

        @Override
        public ReportingRegime.ReportingRegimeBuilder getOrCreateRegimeInformation(int index) {
            if (this.regimeInformation == null) {
                this.regimeInformation = new ArrayList<ReportingRegime.ReportingRegimeBuilder>();
            }
            return (ReportingRegime.ReportingRegimeBuilder)this.getIndex(this.regimeInformation, index, () -> {
                ReportingRegime.ReportingRegimeBuilder newRegimeInformation = ReportingRegime.builder();
                return newRegimeInformation;
            });
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public RegimePartyInformationBuilder setPartyReference(ReferenceWithMetaParty _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        public RegimePartyInformationBuilder setPartyReferenceValue(Party _partyReference) {
            this.getOrCreatePartyReference().setValue(_partyReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="regimeInformation", isRequired=true)
        @RuneAttribute(value="regimeInformation", isRequired=true)
        public RegimePartyInformationBuilder addRegimeInformation(ReportingRegime _regimeInformation) {
            if (_regimeInformation != null) {
                this.regimeInformation.add(_regimeInformation.toBuilder());
            }
            return this;
        }

        @Override
        public RegimePartyInformationBuilder addRegimeInformation(ReportingRegime _regimeInformation, int idx) {
            this.getIndex(this.regimeInformation, idx, () -> _regimeInformation.toBuilder());
            return this;
        }

        @Override
        public RegimePartyInformationBuilder addRegimeInformation(List<? extends ReportingRegime> regimeInformations) {
            if (regimeInformations != null) {
                for (ReportingRegime reportingRegime : regimeInformations) {
                    this.regimeInformation.add(reportingRegime.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regimeInformation")
        public RegimePartyInformationBuilder setRegimeInformation(List<? extends ReportingRegime> regimeInformations) {
            this.regimeInformation = regimeInformations == null ? new ArrayList<ReportingRegime.ReportingRegimeBuilder>() : (List)regimeInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegimePartyInformation build() {
            return new RegimePartyInformationImpl(this);
        }

        @Override
        public RegimePartyInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public RegimePartyInformationBuilder prune() {
            if (this.partyReference != null && !this.partyReference.prune().hasData()) {
                this.partyReference = null;
            }
            this.regimeInformation = this.regimeInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyReference() != null && this.getPartyReference().hasData()) {
                return true;
            }
            return this.getRegimeInformation() != null && this.getRegimeInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public RegimePartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegimePartyInformationBuilder o = (RegimePartyInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyReference(), (RosettaModelObjectBuilder)o.getPartyReference(), this::setPartyReference);
            merger.mergeRosetta(this.getRegimeInformation(), o.getRegimeInformation(), this::getOrCreateRegimeInformation);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegimePartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.regimeInformation, _that.getRegimeInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.regimeInformation != null ? this.regimeInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegimePartyInformationBuilder {partyReference=" + String.valueOf(this.partyReference) + ", regimeInformation=" + String.valueOf(this.regimeInformation) + "}";
        }
    }

    public static interface RegimePartyInformationBuilder
    extends RegimePartyInformation,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreatePartyReference();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getPartyReference();

        public ReportingRegime.ReportingRegimeBuilder getOrCreateRegimeInformation(int var1);

        public List<? extends ReportingRegime.ReportingRegimeBuilder> getRegimeInformation();

        public RegimePartyInformationBuilder setPartyReference(ReferenceWithMetaParty var1);

        public RegimePartyInformationBuilder setPartyReferenceValue(Party var1);

        public RegimePartyInformationBuilder addRegimeInformation(ReportingRegime var1);

        public RegimePartyInformationBuilder addRegimeInformation(ReportingRegime var1, int var2);

        public RegimePartyInformationBuilder addRegimeInformation(List<? extends ReportingRegime> var1);

        public RegimePartyInformationBuilder setRegimeInformation(List<? extends ReportingRegime> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regimeInformation"), processor, ReportingRegime.ReportingRegimeBuilder.class, this.getRegimeInformation(), new AttributeMeta[0]);
        }

        public RegimePartyInformationBuilder prune();
    }

    public static class RegimePartyInformationImpl
    implements RegimePartyInformation {
        private final ReferenceWithMetaParty partyReference;
        private final List<? extends ReportingRegime> regimeInformation;

        protected RegimePartyInformationImpl(RegimePartyInformationBuilder builder) {
            this.partyReference = Optional.ofNullable(builder.getPartyReference()).map(f -> f.build()).orElse(null);
            this.regimeInformation = Optional.ofNullable(builder.getRegimeInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public ReferenceWithMetaParty getPartyReference() {
            return this.partyReference;
        }

        @Override
        @RosettaAttribute(value="regimeInformation", isRequired=true)
        @RuneAttribute(value="regimeInformation", isRequired=true)
        public List<? extends ReportingRegime> getRegimeInformation() {
            return this.regimeInformation;
        }

        @Override
        public RegimePartyInformation build() {
            return this;
        }

        @Override
        public RegimePartyInformationBuilder toBuilder() {
            RegimePartyInformationBuilder builder = RegimePartyInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegimePartyInformationBuilder builder) {
            Optional.ofNullable(this.getPartyReference()).ifPresent(builder::setPartyReference);
            Optional.ofNullable(this.getRegimeInformation()).ifPresent(builder::setRegimeInformation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegimePartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyReference, _that.getPartyReference())) {
                return false;
            }
            return ListEquals.listEquals(this.regimeInformation, _that.getRegimeInformation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyReference != null ? this.partyReference.hashCode() : 0);
            _result = 31 * _result + (this.regimeInformation != null ? this.regimeInformation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegimePartyInformation {partyReference=" + String.valueOf(this.partyReference) + ", regimeInformation=" + String.valueOf(this.regimeInformation) + "}";
        }
    }
}

