/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.event.common.PositionIdentifier;
import cdm.observable.asset.PriceSchedule;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.base.qualification.event.ReportableActionEnum;
import drr.base.trade.ConfirmationMethodEnum;
import drr.base.trade.ExecutionVenueTypeEnum;
import drr.base.trade.PartyInformation;
import drr.base.trade.ReportableInformationBase;
import drr.base.trade.ReportablePriceSource;
import drr.base.trade.basket.CustomBasket;
import drr.enrichment.common.EnrichmentData;
import drr.regulation.common.RegimePartyInformation;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.meta.ReportableInformationMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReportableInformation", builder=ReportableInformationBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="ReportableInformation", model="drr", builder=ReportableInformationBuilderImpl.class, version="7.0.0-dev.92")
public interface ReportableInformation
extends ReportableInformationBase {
    public static final ReportableInformationMeta metaData = new ReportableInformationMeta();

    public List<? extends RegimePartyInformation> getRegimePartyInformation();

    public List<? extends TransactionInformation> getTransactionInformation();

    @Override
    public ReportableInformation build();

    @Override
    public ReportableInformationBuilder toBuilder();

    public static ReportableInformationBuilder builder() {
        return new ReportableInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends ReportableInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReportableInformation> getType() {
        return ReportableInformation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyInformation"), processor, PartyInformation.class, this.getPartyInformation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationMethod"), ConfirmationMethodEnum.class, (Object)this.getConfirmationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionVenueType"), ExecutionVenueTypeEnum.class, (Object)this.getExecutionVenueType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("affiliated"), Boolean.class, (Object)this.getAffiliated(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sefOrDcmAnonymousIndicator"), Boolean.class, (Object)this.getSefOrDcmAnonymousIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalExecutionTimestamp"), ZonedDateTime.class, (Object)this.getOriginalExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoBased"), Boolean.class, (Object)this.getCryptoBased(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAssetLastAvailableSpotPrice"), processor, PriceSchedule.class, (RosettaModelObject)this.getUnderlyingAssetLastAvailableSpotPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyingAssetPriceSource"), processor, ReportablePriceSource.class, this.getUnderlyingAssetPriceSource(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportableAction"), ReportableActionEnum.class, (Object)this.getReportableAction(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("subsequentPositionUTI"), processor, PositionIdentifier.class, (RosettaModelObject)this.getSubsequentPositionUTI(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterpartyPositionPriorUTI"), processor, PositionIdentifier.class, (RosettaModelObject)this.getCounterpartyPositionPriorUTI(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("customBasket"), processor, CustomBasket.class, this.getCustomBasket(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.class, this.getEnrichment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regimePartyInformation"), processor, RegimePartyInformation.class, this.getRegimePartyInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("transactionInformation"), processor, TransactionInformation.class, this.getTransactionInformation(), new AttributeMeta[0]);
    }

    public static class ReportableInformationBuilderImpl
    extends ReportableInformationBase.ReportableInformationBaseBuilderImpl
    implements ReportableInformationBuilder {
        protected List<RegimePartyInformation.RegimePartyInformationBuilder> regimePartyInformation = new ArrayList<RegimePartyInformation.RegimePartyInformationBuilder>();
        protected List<TransactionInformation.TransactionInformationBuilder> transactionInformation = new ArrayList<TransactionInformation.TransactionInformationBuilder>();

        @Override
        @RosettaAttribute(value="regimePartyInformation", isRequired=true)
        @RuneAttribute(value="regimePartyInformation", isRequired=true)
        public List<? extends RegimePartyInformation.RegimePartyInformationBuilder> getRegimePartyInformation() {
            return this.regimePartyInformation;
        }

        @Override
        public RegimePartyInformation.RegimePartyInformationBuilder getOrCreateRegimePartyInformation(int index) {
            if (this.regimePartyInformation == null) {
                this.regimePartyInformation = new ArrayList<RegimePartyInformation.RegimePartyInformationBuilder>();
            }
            return (RegimePartyInformation.RegimePartyInformationBuilder)this.getIndex(this.regimePartyInformation, index, () -> {
                RegimePartyInformation.RegimePartyInformationBuilder newRegimePartyInformation = RegimePartyInformation.builder();
                return newRegimePartyInformation;
            });
        }

        @Override
        @RosettaAttribute(value="transactionInformation")
        @RuneAttribute(value="transactionInformation")
        public List<? extends TransactionInformation.TransactionInformationBuilder> getTransactionInformation() {
            return this.transactionInformation;
        }

        @Override
        public TransactionInformation.TransactionInformationBuilder getOrCreateTransactionInformation(int index) {
            if (this.transactionInformation == null) {
                this.transactionInformation = new ArrayList<TransactionInformation.TransactionInformationBuilder>();
            }
            return (TransactionInformation.TransactionInformationBuilder)this.getIndex(this.transactionInformation, index, () -> {
                TransactionInformation.TransactionInformationBuilder newTransactionInformation = TransactionInformation.builder();
                return newTransactionInformation;
            });
        }

        @Override
        @RosettaAttribute(value="partyInformation", isRequired=true)
        @RuneAttribute(value="partyInformation", isRequired=true)
        public ReportableInformationBuilder addPartyInformation(PartyInformation _partyInformation) {
            if (_partyInformation != null) {
                this.partyInformation.add(_partyInformation.toBuilder());
            }
            return this;
        }

        @Override
        public ReportableInformationBuilder addPartyInformation(PartyInformation _partyInformation, int idx) {
            this.getIndex(this.partyInformation, idx, () -> _partyInformation.toBuilder());
            return this;
        }

        @Override
        public ReportableInformationBuilder addPartyInformation(List<? extends PartyInformation> partyInformations) {
            if (partyInformations != null) {
                for (PartyInformation partyInformation : partyInformations) {
                    this.partyInformation.add(partyInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyInformation")
        public ReportableInformationBuilder setPartyInformation(List<? extends PartyInformation> partyInformations) {
            this.partyInformation = partyInformations == null ? new ArrayList() : (List)partyInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationMethod")
        @RuneAttribute(value="confirmationMethod")
        public ReportableInformationBuilder setConfirmationMethod(ConfirmationMethodEnum _confirmationMethod) {
            this.confirmationMethod = _confirmationMethod == null ? null : _confirmationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionVenueType", isRequired=true)
        @RuneAttribute(value="executionVenueType", isRequired=true)
        public ReportableInformationBuilder setExecutionVenueType(ExecutionVenueTypeEnum _executionVenueType) {
            this.executionVenueType = _executionVenueType == null ? null : _executionVenueType;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public ReportableInformationBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="affiliated")
        @RuneAttribute(value="affiliated")
        public ReportableInformationBuilder setAffiliated(Boolean _affiliated) {
            this.affiliated = _affiliated == null ? null : _affiliated;
            return this;
        }

        @Override
        @RosettaAttribute(value="largeSizeTrade")
        @RuneAttribute(value="largeSizeTrade")
        public ReportableInformationBuilder setLargeSizeTrade(Boolean _largeSizeTrade) {
            this.largeSizeTrade = _largeSizeTrade == null ? null : _largeSizeTrade;
            return this;
        }

        @Override
        @RosettaAttribute(value="sefOrDcmAnonymousIndicator")
        @RuneAttribute(value="sefOrDcmAnonymousIndicator")
        public ReportableInformationBuilder setSefOrDcmAnonymousIndicator(Boolean _sefOrDcmAnonymousIndicator) {
            this.sefOrDcmAnonymousIndicator = _sefOrDcmAnonymousIndicator == null ? null : _sefOrDcmAnonymousIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalExecutionTimestamp")
        @RuneAttribute(value="originalExecutionTimestamp")
        public ReportableInformationBuilder setOriginalExecutionTimestamp(ZonedDateTime _originalExecutionTimestamp) {
            this.originalExecutionTimestamp = _originalExecutionTimestamp == null ? null : _originalExecutionTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoBased")
        @RuneAttribute(value="cryptoBased")
        public ReportableInformationBuilder setCryptoBased(Boolean _cryptoBased) {
            this.cryptoBased = _cryptoBased == null ? null : _cryptoBased;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetLastAvailableSpotPrice")
        @RuneAttribute(value="underlyingAssetLastAvailableSpotPrice")
        public ReportableInformationBuilder setUnderlyingAssetLastAvailableSpotPrice(PriceSchedule _underlyingAssetLastAvailableSpotPrice) {
            this.underlyingAssetLastAvailableSpotPrice = _underlyingAssetLastAvailableSpotPrice == null ? null : _underlyingAssetLastAvailableSpotPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public ReportableInformationBuilder addUnderlyingAssetPriceSource(ReportablePriceSource _underlyingAssetPriceSource) {
            if (_underlyingAssetPriceSource != null) {
                this.underlyingAssetPriceSource.add(_underlyingAssetPriceSource.toBuilder());
            }
            return this;
        }

        @Override
        public ReportableInformationBuilder addUnderlyingAssetPriceSource(ReportablePriceSource _underlyingAssetPriceSource, int idx) {
            this.getIndex(this.underlyingAssetPriceSource, idx, () -> _underlyingAssetPriceSource.toBuilder());
            return this;
        }

        @Override
        public ReportableInformationBuilder addUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> underlyingAssetPriceSources) {
            if (underlyingAssetPriceSources != null) {
                for (ReportablePriceSource reportablePriceSource : underlyingAssetPriceSources) {
                    this.underlyingAssetPriceSource.add(reportablePriceSource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="underlyingAssetPriceSource")
        public ReportableInformationBuilder setUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> underlyingAssetPriceSources) {
            this.underlyingAssetPriceSource = underlyingAssetPriceSources == null ? new ArrayList() : (List)underlyingAssetPriceSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableAction")
        @RuneAttribute(value="reportableAction")
        public ReportableInformationBuilder setReportableAction(ReportableActionEnum _reportableAction) {
            this.reportableAction = _reportableAction == null ? null : _reportableAction;
            return this;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public ReportableInformationBuilder setSubsequentPositionUTI(PositionIdentifier _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterpartyPositionPriorUTI")
        @RuneAttribute(value="counterpartyPositionPriorUTI")
        public ReportableInformationBuilder setCounterpartyPositionPriorUTI(PositionIdentifier _counterpartyPositionPriorUTI) {
            this.counterpartyPositionPriorUTI = _counterpartyPositionPriorUTI == null ? null : _counterpartyPositionPriorUTI.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasket")
        @RuneAttribute(value="customBasket")
        public ReportableInformationBuilder setCustomBasket(CustomBasket _customBasket) {
            this.customBasket = _customBasket == null ? null : _customBasket.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public ReportableInformationBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="enrichment")
        @RuneAttribute(value="enrichment")
        public ReportableInformationBuilder setEnrichment(EnrichmentData _enrichment) {
            this.enrichment = _enrichment == null ? null : _enrichment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regimePartyInformation", isRequired=true)
        @RuneAttribute(value="regimePartyInformation", isRequired=true)
        public ReportableInformationBuilder addRegimePartyInformation(RegimePartyInformation _regimePartyInformation) {
            if (_regimePartyInformation != null) {
                this.regimePartyInformation.add(_regimePartyInformation.toBuilder());
            }
            return this;
        }

        @Override
        public ReportableInformationBuilder addRegimePartyInformation(RegimePartyInformation _regimePartyInformation, int idx) {
            this.getIndex(this.regimePartyInformation, idx, () -> _regimePartyInformation.toBuilder());
            return this;
        }

        @Override
        public ReportableInformationBuilder addRegimePartyInformation(List<? extends RegimePartyInformation> regimePartyInformations) {
            if (regimePartyInformations != null) {
                for (RegimePartyInformation regimePartyInformation : regimePartyInformations) {
                    this.regimePartyInformation.add(regimePartyInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regimePartyInformation")
        public ReportableInformationBuilder setRegimePartyInformation(List<? extends RegimePartyInformation> regimePartyInformations) {
            this.regimePartyInformation = regimePartyInformations == null ? new ArrayList<RegimePartyInformation.RegimePartyInformationBuilder>() : (List)regimePartyInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="transactionInformation")
        @RuneAttribute(value="transactionInformation")
        public ReportableInformationBuilder addTransactionInformation(TransactionInformation _transactionInformation) {
            if (_transactionInformation != null) {
                this.transactionInformation.add(_transactionInformation.toBuilder());
            }
            return this;
        }

        @Override
        public ReportableInformationBuilder addTransactionInformation(TransactionInformation _transactionInformation, int idx) {
            this.getIndex(this.transactionInformation, idx, () -> _transactionInformation.toBuilder());
            return this;
        }

        @Override
        public ReportableInformationBuilder addTransactionInformation(List<? extends TransactionInformation> transactionInformations) {
            if (transactionInformations != null) {
                for (TransactionInformation transactionInformation : transactionInformations) {
                    this.transactionInformation.add(transactionInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="transactionInformation")
        public ReportableInformationBuilder setTransactionInformation(List<? extends TransactionInformation> transactionInformations) {
            this.transactionInformation = transactionInformations == null ? new ArrayList<TransactionInformation.TransactionInformationBuilder>() : (List)transactionInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ReportableInformation build() {
            return new ReportableInformationImpl(this);
        }

        @Override
        public ReportableInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReportableInformationBuilder prune() {
            super.prune();
            this.regimePartyInformation = this.regimePartyInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.transactionInformation = this.transactionInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRegimePartyInformation() != null && this.getRegimePartyInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getTransactionInformation() != null && this.getTransactionInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ReportableInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ReportableInformationBuilder o = (ReportableInformationBuilder)other;
            merger.mergeRosetta(this.getRegimePartyInformation(), o.getRegimePartyInformation(), this::getOrCreateRegimePartyInformation);
            merger.mergeRosetta(this.getTransactionInformation(), o.getTransactionInformation(), this::getOrCreateTransactionInformation);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReportableInformation _that = (ReportableInformation)this.getType().cast(o);
            if (!ListEquals.listEquals(this.regimePartyInformation, _that.getRegimePartyInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.transactionInformation, _that.getTransactionInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimePartyInformation != null ? this.regimePartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.transactionInformation != null ? this.transactionInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReportableInformationBuilder {regimePartyInformation=" + String.valueOf(this.regimePartyInformation) + ", transactionInformation=" + String.valueOf(this.transactionInformation) + "} " + super.toString();
        }
    }

    public static interface ReportableInformationBuilder
    extends ReportableInformation,
    ReportableInformationBase.ReportableInformationBaseBuilder {
        public RegimePartyInformation.RegimePartyInformationBuilder getOrCreateRegimePartyInformation(int var1);

        public List<? extends RegimePartyInformation.RegimePartyInformationBuilder> getRegimePartyInformation();

        public TransactionInformation.TransactionInformationBuilder getOrCreateTransactionInformation(int var1);

        public List<? extends TransactionInformation.TransactionInformationBuilder> getTransactionInformation();

        @Override
        public ReportableInformationBuilder addPartyInformation(PartyInformation var1);

        @Override
        public ReportableInformationBuilder addPartyInformation(PartyInformation var1, int var2);

        @Override
        public ReportableInformationBuilder addPartyInformation(List<? extends PartyInformation> var1);

        @Override
        public ReportableInformationBuilder setPartyInformation(List<? extends PartyInformation> var1);

        @Override
        public ReportableInformationBuilder setConfirmationMethod(ConfirmationMethodEnum var1);

        @Override
        public ReportableInformationBuilder setExecutionVenueType(ExecutionVenueTypeEnum var1);

        @Override
        public ReportableInformationBuilder setIntragroup(Boolean var1);

        @Override
        public ReportableInformationBuilder setAffiliated(Boolean var1);

        @Override
        public ReportableInformationBuilder setLargeSizeTrade(Boolean var1);

        @Override
        public ReportableInformationBuilder setSefOrDcmAnonymousIndicator(Boolean var1);

        @Override
        public ReportableInformationBuilder setOriginalExecutionTimestamp(ZonedDateTime var1);

        @Override
        public ReportableInformationBuilder setCryptoBased(Boolean var1);

        @Override
        public ReportableInformationBuilder setUnderlyingAssetLastAvailableSpotPrice(PriceSchedule var1);

        @Override
        public ReportableInformationBuilder addUnderlyingAssetPriceSource(ReportablePriceSource var1);

        @Override
        public ReportableInformationBuilder addUnderlyingAssetPriceSource(ReportablePriceSource var1, int var2);

        @Override
        public ReportableInformationBuilder addUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> var1);

        @Override
        public ReportableInformationBuilder setUnderlyingAssetPriceSource(List<? extends ReportablePriceSource> var1);

        @Override
        public ReportableInformationBuilder setReportableAction(ReportableActionEnum var1);

        @Override
        public ReportableInformationBuilder setSubsequentPositionUTI(PositionIdentifier var1);

        @Override
        public ReportableInformationBuilder setCounterpartyPositionPriorUTI(PositionIdentifier var1);

        @Override
        public ReportableInformationBuilder setCustomBasket(CustomBasket var1);

        @Override
        public ReportableInformationBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public ReportableInformationBuilder setEnrichment(EnrichmentData var1);

        public ReportableInformationBuilder addRegimePartyInformation(RegimePartyInformation var1);

        public ReportableInformationBuilder addRegimePartyInformation(RegimePartyInformation var1, int var2);

        public ReportableInformationBuilder addRegimePartyInformation(List<? extends RegimePartyInformation> var1);

        public ReportableInformationBuilder setRegimePartyInformation(List<? extends RegimePartyInformation> var1);

        public ReportableInformationBuilder addTransactionInformation(TransactionInformation var1);

        public ReportableInformationBuilder addTransactionInformation(TransactionInformation var1, int var2);

        public ReportableInformationBuilder addTransactionInformation(List<? extends TransactionInformation> var1);

        public ReportableInformationBuilder setTransactionInformation(List<? extends TransactionInformation> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyInformation"), processor, PartyInformation.PartyInformationBuilder.class, this.getPartyInformation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationMethod"), ConfirmationMethodEnum.class, (Object)this.getConfirmationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionVenueType"), ExecutionVenueTypeEnum.class, (Object)this.getExecutionVenueType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("affiliated"), Boolean.class, (Object)this.getAffiliated(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("largeSizeTrade"), Boolean.class, (Object)this.getLargeSizeTrade(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sefOrDcmAnonymousIndicator"), Boolean.class, (Object)this.getSefOrDcmAnonymousIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalExecutionTimestamp"), ZonedDateTime.class, (Object)this.getOriginalExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoBased"), Boolean.class, (Object)this.getCryptoBased(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAssetLastAvailableSpotPrice"), processor, PriceSchedule.PriceScheduleBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyingAssetLastAvailableSpotPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyingAssetPriceSource"), processor, ReportablePriceSource.ReportablePriceSourceBuilder.class, this.getUnderlyingAssetPriceSource(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportableAction"), ReportableActionEnum.class, (Object)this.getReportableAction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("subsequentPositionUTI"), processor, PositionIdentifier.PositionIdentifierBuilder.class, (RosettaModelObjectBuilder)this.getSubsequentPositionUTI(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterpartyPositionPriorUTI"), processor, PositionIdentifier.PositionIdentifierBuilder.class, (RosettaModelObjectBuilder)this.getCounterpartyPositionPriorUTI(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("customBasket"), processor, CustomBasket.CustomBasketBuilder.class, (RosettaModelObjectBuilder)this.getCustomBasket(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("enrichment"), processor, EnrichmentData.EnrichmentDataBuilder.class, (RosettaModelObjectBuilder)this.getEnrichment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regimePartyInformation"), processor, RegimePartyInformation.RegimePartyInformationBuilder.class, this.getRegimePartyInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("transactionInformation"), processor, TransactionInformation.TransactionInformationBuilder.class, this.getTransactionInformation(), new AttributeMeta[0]);
        }

        @Override
        public ReportableInformationBuilder prune();
    }

    public static class ReportableInformationImpl
    extends ReportableInformationBase.ReportableInformationBaseImpl
    implements ReportableInformation {
        private final List<? extends RegimePartyInformation> regimePartyInformation;
        private final List<? extends TransactionInformation> transactionInformation;

        protected ReportableInformationImpl(ReportableInformationBuilder builder) {
            super(builder);
            this.regimePartyInformation = Optional.ofNullable(builder.getRegimePartyInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.transactionInformation = Optional.ofNullable(builder.getTransactionInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regimePartyInformation", isRequired=true)
        @RuneAttribute(value="regimePartyInformation", isRequired=true)
        public List<? extends RegimePartyInformation> getRegimePartyInformation() {
            return this.regimePartyInformation;
        }

        @Override
        @RosettaAttribute(value="transactionInformation")
        @RuneAttribute(value="transactionInformation")
        public List<? extends TransactionInformation> getTransactionInformation() {
            return this.transactionInformation;
        }

        @Override
        public ReportableInformation build() {
            return this;
        }

        @Override
        public ReportableInformationBuilder toBuilder() {
            ReportableInformationBuilder builder = ReportableInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReportableInformationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRegimePartyInformation()).ifPresent(builder::setRegimePartyInformation);
            Optional.ofNullable(this.getTransactionInformation()).ifPresent(builder::setTransactionInformation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReportableInformation _that = (ReportableInformation)this.getType().cast(o);
            if (!ListEquals.listEquals(this.regimePartyInformation, _that.getRegimePartyInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.transactionInformation, _that.getTransactionInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimePartyInformation != null ? this.regimePartyInformation.hashCode() : 0);
            _result = 31 * _result + (this.transactionInformation != null ? this.transactionInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReportableInformation {regimePartyInformation=" + String.valueOf(this.regimePartyInformation) + ", transactionInformation=" + String.valueOf(this.transactionInformation) + "} " + super.toString();
        }
    }
}

