/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.event.common.CounterpartyPositionState;
import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.base.trade.ReportableInformationBase;
import drr.base.trade.ReportingSide;
import drr.base.trade.TransactionReportInstructionBase;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.meta.TransactionReportInstructionMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="TransactionReportInstruction", builder=TransactionReportInstructionBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="TransactionReportInstruction", model="drr", builder=TransactionReportInstructionBuilderImpl.class, version="7.0.0-dev.92")
public interface TransactionReportInstruction
extends TransactionReportInstructionBase {
    public static final TransactionReportInstructionMeta metaData = new TransactionReportInstructionMeta();

    @Override
    public ReportableInformation getReportableInformation();

    @Override
    public TransactionReportInstruction build();

    @Override
    public TransactionReportInstructionBuilder toBuilder();

    public static TransactionReportInstructionBuilder builder() {
        return new TransactionReportInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends TransactionReportInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TransactionReportInstruction> getType() {
        return TransactionReportInstruction.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("originatingWorkflowStep"), processor, WorkflowStep.class, (RosettaModelObject)this.getOriginatingWorkflowStep(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableTrade"), processor, TradeState.class, (RosettaModelObject)this.getReportableTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportablePosition"), processor, CounterpartyPositionState.class, (RosettaModelObject)this.getReportablePosition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, this.getReportingSide(), new AttributeMeta[0]);
    }

    public static class TransactionReportInstructionBuilderImpl
    implements TransactionReportInstructionBuilder {
        protected WorkflowStep.WorkflowStepBuilder originatingWorkflowStep;
        protected TradeState.TradeStateBuilder reportableTrade;
        protected CounterpartyPositionState.CounterpartyPositionStateBuilder reportablePosition;
        protected ReportableInformation.ReportableInformationBuilder reportableInformation;
        protected ReportingSide.ReportingSideBuilder reportingSide;

        @Override
        @RosettaAttribute(value="originatingWorkflowStep", isRequired=true)
        @RuneAttribute(value="originatingWorkflowStep", isRequired=true)
        public WorkflowStep.WorkflowStepBuilder getOriginatingWorkflowStep() {
            return this.originatingWorkflowStep;
        }

        @Override
        public WorkflowStep.WorkflowStepBuilder getOrCreateOriginatingWorkflowStep() {
            WorkflowStep.WorkflowStepBuilder result = this.originatingWorkflowStep != null ? this.originatingWorkflowStep : (this.originatingWorkflowStep = WorkflowStep.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportableTrade")
        @RuneAttribute(value="reportableTrade")
        public TradeState.TradeStateBuilder getReportableTrade() {
            return this.reportableTrade;
        }

        @Override
        public TradeState.TradeStateBuilder getOrCreateReportableTrade() {
            TradeState.TradeStateBuilder result = this.reportableTrade != null ? this.reportableTrade : (this.reportableTrade = TradeState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportablePosition")
        @RuneAttribute(value="reportablePosition")
        public CounterpartyPositionState.CounterpartyPositionStateBuilder getReportablePosition() {
            return this.reportablePosition;
        }

        @Override
        public CounterpartyPositionState.CounterpartyPositionStateBuilder getOrCreateReportablePosition() {
            CounterpartyPositionState.CounterpartyPositionStateBuilder result = this.reportablePosition != null ? this.reportablePosition : (this.reportablePosition = CounterpartyPositionState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ReportableInformation.ReportableInformationBuilder getReportableInformation() {
            return this.reportableInformation;
        }

        @Override
        public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation() {
            ReportableInformation.ReportableInformationBuilder result = this.reportableInformation != null ? this.reportableInformation : (this.reportableInformation = ReportableInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide.ReportingSideBuilder getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
            ReportingSide.ReportingSideBuilder result = this.reportingSide != null ? this.reportingSide : (this.reportingSide = ReportingSide.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originatingWorkflowStep", isRequired=true)
        @RuneAttribute(value="originatingWorkflowStep", isRequired=true)
        public TransactionReportInstructionBuilder setOriginatingWorkflowStep(WorkflowStep _originatingWorkflowStep) {
            this.originatingWorkflowStep = _originatingWorkflowStep == null ? null : _originatingWorkflowStep.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableTrade")
        @RuneAttribute(value="reportableTrade")
        public TransactionReportInstructionBuilder setReportableTrade(TradeState _reportableTrade) {
            this.reportableTrade = _reportableTrade == null ? null : _reportableTrade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportablePosition")
        @RuneAttribute(value="reportablePosition")
        public TransactionReportInstructionBuilder setReportablePosition(CounterpartyPositionState _reportablePosition) {
            this.reportablePosition = _reportablePosition == null ? null : _reportablePosition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public TransactionReportInstructionBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public TransactionReportInstructionBuilder setReportableInformation(ReportableInformationBase _reportableInformation) {
            ReportableInformation ifThenElseResult = _reportableInformation == null ? null : (_reportableInformation instanceof ReportableInformation ? (ReportableInformation)ReportableInformation.class.cast(_reportableInformation) : null);
            return this.setReportableInformation(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public TransactionReportInstructionBuilder setReportingSide(ReportingSide _reportingSide) {
            this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
            return this;
        }

        @Override
        public TransactionReportInstruction build() {
            return new TransactionReportInstructionImpl(this);
        }

        @Override
        public TransactionReportInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public TransactionReportInstructionBuilder prune() {
            if (this.originatingWorkflowStep != null && !this.originatingWorkflowStep.prune().hasData()) {
                this.originatingWorkflowStep = null;
            }
            if (this.reportableTrade != null && !this.reportableTrade.prune().hasData()) {
                this.reportableTrade = null;
            }
            if (this.reportablePosition != null && !this.reportablePosition.prune().hasData()) {
                this.reportablePosition = null;
            }
            if (this.reportableInformation != null && !this.reportableInformation.prune().hasData()) {
                this.reportableInformation = null;
            }
            if (this.reportingSide != null && !this.reportingSide.prune().hasData()) {
                this.reportingSide = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getOriginatingWorkflowStep() != null && this.getOriginatingWorkflowStep().hasData()) {
                return true;
            }
            if (this.getReportableTrade() != null && this.getReportableTrade().hasData()) {
                return true;
            }
            if (this.getReportablePosition() != null && this.getReportablePosition().hasData()) {
                return true;
            }
            if (this.getReportableInformation() != null && this.getReportableInformation().hasData()) {
                return true;
            }
            return this.getReportingSide() != null && this.getReportingSide().hasData();
        }

        public TransactionReportInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TransactionReportInstructionBuilder o = (TransactionReportInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginatingWorkflowStep(), (RosettaModelObjectBuilder)o.getOriginatingWorkflowStep(), this::setOriginatingWorkflowStep);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportableTrade(), (RosettaModelObjectBuilder)o.getReportableTrade(), this::setReportableTrade);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportablePosition(), (RosettaModelObjectBuilder)o.getReportablePosition(), this::setReportablePosition);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportableInformation(), (RosettaModelObjectBuilder)o.getReportableInformation(), this::setReportableInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingSide(), (RosettaModelObjectBuilder)o.getReportingSide(), this::setReportingSide);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransactionReportInstruction _that = this.getType().cast(o);
            if (!Objects.equals(this.originatingWorkflowStep, _that.getOriginatingWorkflowStep())) {
                return false;
            }
            if (!Objects.equals(this.reportableTrade, _that.getReportableTrade())) {
                return false;
            }
            if (!Objects.equals(this.reportablePosition, _that.getReportablePosition())) {
                return false;
            }
            if (!Objects.equals(this.reportableInformation, _that.getReportableInformation())) {
                return false;
            }
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.originatingWorkflowStep != null ? this.originatingWorkflowStep.hashCode() : 0);
            _result = 31 * _result + (this.reportableTrade != null ? this.reportableTrade.hashCode() : 0);
            _result = 31 * _result + (this.reportablePosition != null ? this.reportablePosition.hashCode() : 0);
            _result = 31 * _result + (this.reportableInformation != null ? this.reportableInformation.hashCode() : 0);
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransactionReportInstructionBuilder {originatingWorkflowStep=" + String.valueOf(this.originatingWorkflowStep) + ", reportableTrade=" + String.valueOf(this.reportableTrade) + ", reportablePosition=" + String.valueOf(this.reportablePosition) + ", reportableInformation=" + String.valueOf(this.reportableInformation) + ", reportingSide=" + String.valueOf(this.reportingSide) + "}";
        }
    }

    public static interface TransactionReportInstructionBuilder
    extends TransactionReportInstruction,
    TransactionReportInstructionBase.TransactionReportInstructionBaseBuilder {
        @Override
        public ReportableInformation.ReportableInformationBuilder getOrCreateReportableInformation();

        @Override
        public ReportableInformation.ReportableInformationBuilder getReportableInformation();

        @Override
        public TransactionReportInstructionBuilder setOriginatingWorkflowStep(WorkflowStep var1);

        @Override
        public TransactionReportInstructionBuilder setReportableTrade(TradeState var1);

        @Override
        public TransactionReportInstructionBuilder setReportablePosition(CounterpartyPositionState var1);

        @Override
        public TransactionReportInstructionBuilder setReportableInformation(ReportableInformationBase var1);

        @Override
        public TransactionReportInstructionBuilder setReportingSide(ReportingSide var1);

        public TransactionReportInstructionBuilder setReportableInformation(ReportableInformation var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("originatingWorkflowStep"), processor, WorkflowStep.WorkflowStepBuilder.class, (RosettaModelObjectBuilder)this.getOriginatingWorkflowStep(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableTrade"), processor, TradeState.TradeStateBuilder.class, (RosettaModelObjectBuilder)this.getReportableTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportablePosition"), processor, CounterpartyPositionState.CounterpartyPositionStateBuilder.class, (RosettaModelObjectBuilder)this.getReportablePosition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, (RosettaModelObjectBuilder)this.getReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public TransactionReportInstructionBuilder prune();
    }

    public static class TransactionReportInstructionImpl
    extends TransactionReportInstructionBase.TransactionReportInstructionBaseImpl
    implements TransactionReportInstruction {
        private final ReportableInformation reportableInformation;

        protected TransactionReportInstructionImpl(TransactionReportInstructionBuilder builder) {
            super(builder);
            this.reportableInformation = Optional.ofNullable(builder.getReportableInformation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ReportableInformation getReportableInformation() {
            return this.reportableInformation;
        }

        @Override
        public TransactionReportInstruction build() {
            return this;
        }

        @Override
        public TransactionReportInstructionBuilder toBuilder() {
            TransactionReportInstructionBuilder builder = TransactionReportInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransactionReportInstructionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportableInformation()).ifPresent(builder::setReportableInformation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            TransactionReportInstruction _that = (TransactionReportInstruction)this.getType().cast(o);
            return Objects.equals(this.reportableInformation, _that.getReportableInformation());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportableInformation != null ? this.reportableInformation.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "TransactionReportInstruction {reportableInformation=" + String.valueOf(this.reportableInformation) + "} " + super.toString();
        }
    }
}

