/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.dtcc.valuation;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.dtcc.valuation.meta.DTCCCommonValuationFieldsMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="DTCCCommonValuationFields", builder=DTCCCommonValuationFieldsBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="DTCCCommonValuationFields", model="drr", builder=DTCCCommonValuationFieldsBuilderImpl.class, version="7.0.0-dev.92")
public interface DTCCCommonValuationFields
extends RosettaModelObject {
    public static final DTCCCommonValuationFieldsMeta metaData = new DTCCCommonValuationFieldsMeta();

    public PartyIdentifierTypeEnum getTradeParty1IDType();

    public PartyIdentifierTypeEnum getSubmittingPartyIDType();

    public String getUsiIDPrefix();

    public String getUtiIDPrefix();

    public String getSubmittedForParty();

    public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination();

    public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination();

    public AssetClassEnum getPrimaryAssetClass();

    public String getComment1();

    public String getMessageID();

    public String getMessageType();

    public String getTradeParty2ExecutionAgentID();

    public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType();

    public String getTradeParty1ExecutionAgentID();

    public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType();

    public String getTradeParty1TransactionID();

    public String getVersion();

    public DTCCCommonValuationFields build();

    public DTCCCommonValuationFieldsBuilder toBuilder();

    public static DTCCCommonValuationFieldsBuilder builder() {
        return new DTCCCommonValuationFieldsBuilderImpl();
    }

    default public RosettaMetaData<? extends DTCCCommonValuationFields> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DTCCCommonValuationFields> getType() {
        return DTCCCommonValuationFields.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class DTCCCommonValuationFieldsBuilderImpl
    implements DTCCCommonValuationFieldsBuilder {
        protected PartyIdentifierTypeEnum tradeParty1IDType;
        protected PartyIdentifierTypeEnum submittingPartyIDType;
        protected String usiIDPrefix;
        protected String utiIDPrefix;
        protected String submittedForParty;
        protected List<SupervisoryBodyEnum> tradeParty1ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected List<SupervisoryBodyEnum> tradeParty2ReportingDestination = new ArrayList<SupervisoryBodyEnum>();
        protected AssetClassEnum primaryAssetClass;
        protected String comment1;
        protected String messageID;
        protected String messageType;
        protected String tradeParty2ExecutionAgentID;
        protected PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
        protected String tradeParty1ExecutionAgentID;
        protected PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
        protected String tradeParty1TransactionID;
        protected String version;

        @Override
        @RosettaAttribute(value="tradeParty1IDType")
        @RuneAttribute(value="tradeParty1IDType")
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType")
        @RuneAttribute(value="submittingPartyIDType")
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="submittedForParty")
        @RuneAttribute(value="submittedForParty")
        public String getSubmittedForParty() {
            return this.submittedForParty;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination")
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
            return this.tradeParty2ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public AssetClassEnum getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType")
        @RuneAttribute(value="messageType")
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public String getTradeParty2ExecutionAgentID() {
            return this.tradeParty2ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
            return this.tradeParty2ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public String getTradeParty1ExecutionAgentID() {
            return this.tradeParty1ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
            return this.tradeParty1ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public String getTradeParty1TransactionID() {
            return this.tradeParty1TransactionID;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public String getVersion() {
            return this.version;
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType")
        @RuneAttribute(value="tradeParty1IDType")
        public DTCCCommonValuationFieldsBuilder setTradeParty1IDType(PartyIdentifierTypeEnum _tradeParty1IDType) {
            this.tradeParty1IDType = _tradeParty1IDType == null ? null : _tradeParty1IDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType")
        @RuneAttribute(value="submittingPartyIDType")
        public DTCCCommonValuationFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum _submittingPartyIDType) {
            this.submittingPartyIDType = _submittingPartyIDType == null ? null : _submittingPartyIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public DTCCCommonValuationFieldsBuilder setUsiIDPrefix(String _usiIDPrefix) {
            this.usiIDPrefix = _usiIDPrefix == null ? null : _usiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public DTCCCommonValuationFieldsBuilder setUtiIDPrefix(String _utiIDPrefix) {
            this.utiIDPrefix = _utiIDPrefix == null ? null : _utiIDPrefix;
            return this;
        }

        @Override
        @RosettaAttribute(value="submittedForParty")
        @RuneAttribute(value="submittedForParty")
        public DTCCCommonValuationFieldsBuilder setSubmittedForParty(String _submittedForParty) {
            this.submittedForParty = _submittedForParty == null ? null : _submittedForParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination")
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public DTCCCommonValuationFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination) {
            if (_tradeParty1ReportingDestination != null) {
                this.tradeParty1ReportingDestination.add(_tradeParty1ReportingDestination);
            }
            return this;
        }

        @Override
        public DTCCCommonValuationFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum _tradeParty1ReportingDestination, int idx) {
            this.getIndex(this.tradeParty1ReportingDestination, idx, () -> _tradeParty1ReportingDestination);
            return this;
        }

        @Override
        public DTCCCommonValuationFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            if (tradeParty1ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty1ReportingDestinations) {
                    this.tradeParty1ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public DTCCCommonValuationFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> tradeParty1ReportingDestinations) {
            this.tradeParty1ReportingDestination = tradeParty1ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty1ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public DTCCCommonValuationFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination) {
            if (_tradeParty2ReportingDestination != null) {
                this.tradeParty2ReportingDestination.add(_tradeParty2ReportingDestination);
            }
            return this;
        }

        @Override
        public DTCCCommonValuationFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum _tradeParty2ReportingDestination, int idx) {
            this.getIndex(this.tradeParty2ReportingDestination, idx, () -> _tradeParty2ReportingDestination);
            return this;
        }

        @Override
        public DTCCCommonValuationFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            if (tradeParty2ReportingDestinations != null) {
                for (SupervisoryBodyEnum toAdd : tradeParty2ReportingDestinations) {
                    this.tradeParty2ReportingDestination.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public DTCCCommonValuationFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> tradeParty2ReportingDestinations) {
            this.tradeParty2ReportingDestination = tradeParty2ReportingDestinations == null ? new ArrayList<SupervisoryBodyEnum>() : (List)tradeParty2ReportingDestinations.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public DTCCCommonValuationFieldsBuilder setPrimaryAssetClass(AssetClassEnum _primaryAssetClass) {
            this.primaryAssetClass = _primaryAssetClass == null ? null : _primaryAssetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public DTCCCommonValuationFieldsBuilder setComment1(String _comment1) {
            this.comment1 = _comment1 == null ? null : _comment1;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public DTCCCommonValuationFieldsBuilder setMessageID(String _messageID) {
            this.messageID = _messageID == null ? null : _messageID;
            return this;
        }

        @Override
        @RosettaAttribute(value="messageType")
        @RuneAttribute(value="messageType")
        public DTCCCommonValuationFieldsBuilder setMessageType(String _messageType) {
            this.messageType = _messageType == null ? null : _messageType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public DTCCCommonValuationFieldsBuilder setTradeParty2ExecutionAgentID(String _tradeParty2ExecutionAgentID) {
            this.tradeParty2ExecutionAgentID = _tradeParty2ExecutionAgentID == null ? null : _tradeParty2ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public DTCCCommonValuationFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty2ExecutionAgentIDType) {
            this.tradeParty2ExecutionAgentIDType = _tradeParty2ExecutionAgentIDType == null ? null : _tradeParty2ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public DTCCCommonValuationFieldsBuilder setTradeParty1ExecutionAgentID(String _tradeParty1ExecutionAgentID) {
            this.tradeParty1ExecutionAgentID = _tradeParty1ExecutionAgentID == null ? null : _tradeParty1ExecutionAgentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public DTCCCommonValuationFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum _tradeParty1ExecutionAgentIDType) {
            this.tradeParty1ExecutionAgentIDType = _tradeParty1ExecutionAgentIDType == null ? null : _tradeParty1ExecutionAgentIDType;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public DTCCCommonValuationFieldsBuilder setTradeParty1TransactionID(String _tradeParty1TransactionID) {
            this.tradeParty1TransactionID = _tradeParty1TransactionID == null ? null : _tradeParty1TransactionID;
            return this;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public DTCCCommonValuationFieldsBuilder setVersion(String _version) {
            this.version = _version == null ? null : _version;
            return this;
        }

        @Override
        public DTCCCommonValuationFields build() {
            return new DTCCCommonValuationFieldsImpl(this);
        }

        @Override
        public DTCCCommonValuationFieldsBuilder toBuilder() {
            return this;
        }

        @Override
        public DTCCCommonValuationFieldsBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getTradeParty1IDType() != null) {
                return true;
            }
            if (this.getSubmittingPartyIDType() != null) {
                return true;
            }
            if (this.getUsiIDPrefix() != null) {
                return true;
            }
            if (this.getUtiIDPrefix() != null) {
                return true;
            }
            if (this.getSubmittedForParty() != null) {
                return true;
            }
            if (this.getTradeParty1ReportingDestination() != null && !this.getTradeParty1ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getTradeParty2ReportingDestination() != null && !this.getTradeParty2ReportingDestination().isEmpty()) {
                return true;
            }
            if (this.getPrimaryAssetClass() != null) {
                return true;
            }
            if (this.getComment1() != null) {
                return true;
            }
            if (this.getMessageID() != null) {
                return true;
            }
            if (this.getMessageType() != null) {
                return true;
            }
            if (this.getTradeParty2ExecutionAgentID() != null) {
                return true;
            }
            if (this.getTradeParty2ExecutionAgentIDType() != null) {
                return true;
            }
            if (this.getTradeParty1ExecutionAgentID() != null) {
                return true;
            }
            if (this.getTradeParty1ExecutionAgentIDType() != null) {
                return true;
            }
            if (this.getTradeParty1TransactionID() != null) {
                return true;
            }
            return this.getVersion() != null;
        }

        public DTCCCommonValuationFieldsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DTCCCommonValuationFieldsBuilder o = (DTCCCommonValuationFieldsBuilder)other;
            merger.mergeBasic((Object)this.getTradeParty1IDType(), (Object)o.getTradeParty1IDType(), this::setTradeParty1IDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittingPartyIDType(), (Object)o.getSubmittingPartyIDType(), this::setSubmittingPartyIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUsiIDPrefix(), (Object)o.getUsiIDPrefix(), this::setUsiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUtiIDPrefix(), (Object)o.getUtiIDPrefix(), this::setUtiIDPrefix, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmittedForParty(), (Object)o.getSubmittedForParty(), this::setSubmittedForParty, new AttributeMeta[0]);
            merger.mergeBasic(this.getTradeParty1ReportingDestination(), o.getTradeParty1ReportingDestination(), this::addTradeParty1ReportingDestination);
            merger.mergeBasic(this.getTradeParty2ReportingDestination(), o.getTradeParty2ReportingDestination(), this::addTradeParty2ReportingDestination);
            merger.mergeBasic((Object)this.getPrimaryAssetClass(), (Object)o.getPrimaryAssetClass(), this::setPrimaryAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getComment1(), (Object)o.getComment1(), this::setComment1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageID(), (Object)o.getMessageID(), this::setMessageID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMessageType(), (Object)o.getMessageType(), this::setMessageType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty2ExecutionAgentID(), (Object)o.getTradeParty2ExecutionAgentID(), this::setTradeParty2ExecutionAgentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty2ExecutionAgentIDType(), (Object)o.getTradeParty2ExecutionAgentIDType(), this::setTradeParty2ExecutionAgentIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1ExecutionAgentID(), (Object)o.getTradeParty1ExecutionAgentID(), this::setTradeParty1ExecutionAgentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1ExecutionAgentIDType(), (Object)o.getTradeParty1ExecutionAgentIDType(), this::setTradeParty1ExecutionAgentIDType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTradeParty1TransactionID(), (Object)o.getTradeParty1TransactionID(), this::setTradeParty1TransactionID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVersion(), (Object)o.getVersion(), this::setVersion, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DTCCCommonValuationFields _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.submittedForParty, _that.getSubmittedForParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1TransactionID, _that.getTradeParty1TransactionID())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.submittedForParty != null ? this.submittedForParty.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.tradeParty2ReportingDestination != null ? this.tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentID != null ? this.tradeParty2ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentIDType != null ? this.tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentID != null ? this.tradeParty1ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentIDType != null ? this.tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1TransactionID != null ? this.tradeParty1TransactionID.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DTCCCommonValuationFieldsBuilder {tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", submittedForParty=" + this.submittedForParty + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", tradeParty2ReportingDestination=" + String.valueOf(this.tradeParty2ReportingDestination) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", tradeParty2ExecutionAgentIDType=" + String.valueOf(this.tradeParty2ExecutionAgentIDType) + ", tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", tradeParty1ExecutionAgentIDType=" + String.valueOf(this.tradeParty1ExecutionAgentIDType) + ", tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", version=" + this.version + "}";
        }
    }

    public static interface DTCCCommonValuationFieldsBuilder
    extends DTCCCommonValuationFields,
    RosettaModelObjectBuilder {
        public DTCCCommonValuationFieldsBuilder setTradeParty1IDType(PartyIdentifierTypeEnum var1);

        public DTCCCommonValuationFieldsBuilder setSubmittingPartyIDType(PartyIdentifierTypeEnum var1);

        public DTCCCommonValuationFieldsBuilder setUsiIDPrefix(String var1);

        public DTCCCommonValuationFieldsBuilder setUtiIDPrefix(String var1);

        public DTCCCommonValuationFieldsBuilder setSubmittedForParty(String var1);

        public DTCCCommonValuationFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1);

        public DTCCCommonValuationFieldsBuilder addTradeParty1ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public DTCCCommonValuationFieldsBuilder addTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public DTCCCommonValuationFieldsBuilder setTradeParty1ReportingDestination(List<SupervisoryBodyEnum> var1);

        public DTCCCommonValuationFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1);

        public DTCCCommonValuationFieldsBuilder addTradeParty2ReportingDestination(SupervisoryBodyEnum var1, int var2);

        public DTCCCommonValuationFieldsBuilder addTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        public DTCCCommonValuationFieldsBuilder setTradeParty2ReportingDestination(List<SupervisoryBodyEnum> var1);

        public DTCCCommonValuationFieldsBuilder setPrimaryAssetClass(AssetClassEnum var1);

        public DTCCCommonValuationFieldsBuilder setComment1(String var1);

        public DTCCCommonValuationFieldsBuilder setMessageID(String var1);

        public DTCCCommonValuationFieldsBuilder setMessageType(String var1);

        public DTCCCommonValuationFieldsBuilder setTradeParty2ExecutionAgentID(String var1);

        public DTCCCommonValuationFieldsBuilder setTradeParty2ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        public DTCCCommonValuationFieldsBuilder setTradeParty1ExecutionAgentID(String var1);

        public DTCCCommonValuationFieldsBuilder setTradeParty1ExecutionAgentIDType(PartyIdentifierTypeEnum var1);

        public DTCCCommonValuationFieldsBuilder setTradeParty1TransactionID(String var1);

        public DTCCCommonValuationFieldsBuilder setVersion(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("tradeParty1IDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1IDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittingPartyIDType"), PartyIdentifierTypeEnum.class, (Object)this.getSubmittingPartyIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("usiIDPrefix"), String.class, (Object)this.getUsiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("utiIDPrefix"), String.class, (Object)this.getUtiIDPrefix(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submittedForParty"), String.class, (Object)this.getSubmittedForParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty1ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ReportingDestination"), SupervisoryBodyEnum.class, this.getTradeParty2ReportingDestination(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("primaryAssetClass"), AssetClassEnum.class, (Object)this.getPrimaryAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment1"), String.class, (Object)this.getComment1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageID"), String.class, (Object)this.getMessageID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("messageType"), String.class, (Object)this.getMessageType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentID"), String.class, (Object)this.getTradeParty2ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty2ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty2ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentID"), String.class, (Object)this.getTradeParty1ExecutionAgentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1ExecutionAgentIDType"), PartyIdentifierTypeEnum.class, (Object)this.getTradeParty1ExecutionAgentIDType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradeParty1TransactionID"), String.class, (Object)this.getTradeParty1TransactionID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("version"), String.class, (Object)this.getVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public DTCCCommonValuationFieldsBuilder prune();
    }

    public static class DTCCCommonValuationFieldsImpl
    implements DTCCCommonValuationFields {
        private final PartyIdentifierTypeEnum tradeParty1IDType;
        private final PartyIdentifierTypeEnum submittingPartyIDType;
        private final String usiIDPrefix;
        private final String utiIDPrefix;
        private final String submittedForParty;
        private final List<SupervisoryBodyEnum> tradeParty1ReportingDestination;
        private final List<SupervisoryBodyEnum> tradeParty2ReportingDestination;
        private final AssetClassEnum primaryAssetClass;
        private final String comment1;
        private final String messageID;
        private final String messageType;
        private final String tradeParty2ExecutionAgentID;
        private final PartyIdentifierTypeEnum tradeParty2ExecutionAgentIDType;
        private final String tradeParty1ExecutionAgentID;
        private final PartyIdentifierTypeEnum tradeParty1ExecutionAgentIDType;
        private final String tradeParty1TransactionID;
        private final String version;

        protected DTCCCommonValuationFieldsImpl(DTCCCommonValuationFieldsBuilder builder) {
            this.tradeParty1IDType = builder.getTradeParty1IDType();
            this.submittingPartyIDType = builder.getSubmittingPartyIDType();
            this.usiIDPrefix = builder.getUsiIDPrefix();
            this.utiIDPrefix = builder.getUtiIDPrefix();
            this.submittedForParty = builder.getSubmittedForParty();
            this.tradeParty1ReportingDestination = Optional.ofNullable(builder.getTradeParty1ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.tradeParty2ReportingDestination = Optional.ofNullable(builder.getTradeParty2ReportingDestination()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.primaryAssetClass = builder.getPrimaryAssetClass();
            this.comment1 = builder.getComment1();
            this.messageID = builder.getMessageID();
            this.messageType = builder.getMessageType();
            this.tradeParty2ExecutionAgentID = builder.getTradeParty2ExecutionAgentID();
            this.tradeParty2ExecutionAgentIDType = builder.getTradeParty2ExecutionAgentIDType();
            this.tradeParty1ExecutionAgentID = builder.getTradeParty1ExecutionAgentID();
            this.tradeParty1ExecutionAgentIDType = builder.getTradeParty1ExecutionAgentIDType();
            this.tradeParty1TransactionID = builder.getTradeParty1TransactionID();
            this.version = builder.getVersion();
        }

        @Override
        @RosettaAttribute(value="tradeParty1IDType")
        @RuneAttribute(value="tradeParty1IDType")
        public PartyIdentifierTypeEnum getTradeParty1IDType() {
            return this.tradeParty1IDType;
        }

        @Override
        @RosettaAttribute(value="submittingPartyIDType")
        @RuneAttribute(value="submittingPartyIDType")
        public PartyIdentifierTypeEnum getSubmittingPartyIDType() {
            return this.submittingPartyIDType;
        }

        @Override
        @RosettaAttribute(value="usiIDPrefix")
        @RuneAttribute(value="usiIDPrefix")
        public String getUsiIDPrefix() {
            return this.usiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="utiIDPrefix")
        @RuneAttribute(value="utiIDPrefix")
        public String getUtiIDPrefix() {
            return this.utiIDPrefix;
        }

        @Override
        @RosettaAttribute(value="submittedForParty")
        @RuneAttribute(value="submittedForParty")
        public String getSubmittedForParty() {
            return this.submittedForParty;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ReportingDestination")
        @RuneAttribute(value="tradeParty1ReportingDestination")
        public List<SupervisoryBodyEnum> getTradeParty1ReportingDestination() {
            return this.tradeParty1ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ReportingDestination")
        @RuneAttribute(value="tradeParty2ReportingDestination")
        public List<SupervisoryBodyEnum> getTradeParty2ReportingDestination() {
            return this.tradeParty2ReportingDestination;
        }

        @Override
        @RosettaAttribute(value="primaryAssetClass", isRequired=true)
        @RuneAttribute(value="primaryAssetClass", isRequired=true)
        public AssetClassEnum getPrimaryAssetClass() {
            return this.primaryAssetClass;
        }

        @Override
        @RosettaAttribute(value="comment1")
        @RuneAttribute(value="comment1")
        public String getComment1() {
            return this.comment1;
        }

        @Override
        @RosettaAttribute(value="messageID")
        @RuneAttribute(value="messageID")
        public String getMessageID() {
            return this.messageID;
        }

        @Override
        @RosettaAttribute(value="messageType")
        @RuneAttribute(value="messageType")
        public String getMessageType() {
            return this.messageType;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentID")
        @RuneAttribute(value="tradeParty2ExecutionAgentID")
        public String getTradeParty2ExecutionAgentID() {
            return this.tradeParty2ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty2ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty2ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty2ExecutionAgentIDType() {
            return this.tradeParty2ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentID")
        @RuneAttribute(value="tradeParty1ExecutionAgentID")
        public String getTradeParty1ExecutionAgentID() {
            return this.tradeParty1ExecutionAgentID;
        }

        @Override
        @RosettaAttribute(value="tradeParty1ExecutionAgentIDType")
        @RuneAttribute(value="tradeParty1ExecutionAgentIDType")
        public PartyIdentifierTypeEnum getTradeParty1ExecutionAgentIDType() {
            return this.tradeParty1ExecutionAgentIDType;
        }

        @Override
        @RosettaAttribute(value="tradeParty1TransactionID")
        @RuneAttribute(value="tradeParty1TransactionID")
        public String getTradeParty1TransactionID() {
            return this.tradeParty1TransactionID;
        }

        @Override
        @RosettaAttribute(value="version")
        @RuneAttribute(value="version")
        public String getVersion() {
            return this.version;
        }

        @Override
        public DTCCCommonValuationFields build() {
            return this;
        }

        @Override
        public DTCCCommonValuationFieldsBuilder toBuilder() {
            DTCCCommonValuationFieldsBuilder builder = DTCCCommonValuationFields.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DTCCCommonValuationFieldsBuilder builder) {
            Optional.ofNullable(this.getTradeParty1IDType()).ifPresent(builder::setTradeParty1IDType);
            Optional.ofNullable(this.getSubmittingPartyIDType()).ifPresent(builder::setSubmittingPartyIDType);
            Optional.ofNullable(this.getUsiIDPrefix()).ifPresent(builder::setUsiIDPrefix);
            Optional.ofNullable(this.getUtiIDPrefix()).ifPresent(builder::setUtiIDPrefix);
            Optional.ofNullable(this.getSubmittedForParty()).ifPresent(builder::setSubmittedForParty);
            Optional.ofNullable(this.getTradeParty1ReportingDestination()).ifPresent(builder::setTradeParty1ReportingDestination);
            Optional.ofNullable(this.getTradeParty2ReportingDestination()).ifPresent(builder::setTradeParty2ReportingDestination);
            Optional.ofNullable(this.getPrimaryAssetClass()).ifPresent(builder::setPrimaryAssetClass);
            Optional.ofNullable(this.getComment1()).ifPresent(builder::setComment1);
            Optional.ofNullable(this.getMessageID()).ifPresent(builder::setMessageID);
            Optional.ofNullable(this.getMessageType()).ifPresent(builder::setMessageType);
            Optional.ofNullable(this.getTradeParty2ExecutionAgentID()).ifPresent(builder::setTradeParty2ExecutionAgentID);
            Optional.ofNullable(this.getTradeParty2ExecutionAgentIDType()).ifPresent(builder::setTradeParty2ExecutionAgentIDType);
            Optional.ofNullable(this.getTradeParty1ExecutionAgentID()).ifPresent(builder::setTradeParty1ExecutionAgentID);
            Optional.ofNullable(this.getTradeParty1ExecutionAgentIDType()).ifPresent(builder::setTradeParty1ExecutionAgentIDType);
            Optional.ofNullable(this.getTradeParty1TransactionID()).ifPresent(builder::setTradeParty1TransactionID);
            Optional.ofNullable(this.getVersion()).ifPresent(builder::setVersion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DTCCCommonValuationFields _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeParty1IDType, _that.getTradeParty1IDType())) {
                return false;
            }
            if (!Objects.equals(this.submittingPartyIDType, _that.getSubmittingPartyIDType())) {
                return false;
            }
            if (!Objects.equals(this.usiIDPrefix, _that.getUsiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.utiIDPrefix, _that.getUtiIDPrefix())) {
                return false;
            }
            if (!Objects.equals(this.submittedForParty, _that.getSubmittedForParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty1ReportingDestination, _that.getTradeParty1ReportingDestination())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradeParty2ReportingDestination, _that.getTradeParty2ReportingDestination())) {
                return false;
            }
            if (!Objects.equals(this.primaryAssetClass, _that.getPrimaryAssetClass())) {
                return false;
            }
            if (!Objects.equals(this.comment1, _that.getComment1())) {
                return false;
            }
            if (!Objects.equals(this.messageID, _that.getMessageID())) {
                return false;
            }
            if (!Objects.equals(this.messageType, _that.getMessageType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentID, _that.getTradeParty2ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty2ExecutionAgentIDType, _that.getTradeParty2ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentID, _that.getTradeParty1ExecutionAgentID())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1ExecutionAgentIDType, _that.getTradeParty1ExecutionAgentIDType())) {
                return false;
            }
            if (!Objects.equals(this.tradeParty1TransactionID, _that.getTradeParty1TransactionID())) {
                return false;
            }
            return Objects.equals(this.version, _that.getVersion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeParty1IDType != null ? this.tradeParty1IDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.submittingPartyIDType != null ? this.submittingPartyIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.usiIDPrefix != null ? this.usiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.utiIDPrefix != null ? this.utiIDPrefix.hashCode() : 0);
            _result = 31 * _result + (this.submittedForParty != null ? this.submittedForParty.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ReportingDestination != null ? this.tradeParty1ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.tradeParty2ReportingDestination != null ? this.tradeParty2ReportingDestination.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.primaryAssetClass != null ? this.primaryAssetClass.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.comment1 != null ? this.comment1.hashCode() : 0);
            _result = 31 * _result + (this.messageID != null ? this.messageID.hashCode() : 0);
            _result = 31 * _result + (this.messageType != null ? this.messageType.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentID != null ? this.tradeParty2ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty2ExecutionAgentIDType != null ? this.tradeParty2ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentID != null ? this.tradeParty1ExecutionAgentID.hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1ExecutionAgentIDType != null ? this.tradeParty1ExecutionAgentIDType.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.tradeParty1TransactionID != null ? this.tradeParty1TransactionID.hashCode() : 0);
            _result = 31 * _result + (this.version != null ? this.version.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DTCCCommonValuationFields {tradeParty1IDType=" + String.valueOf(this.tradeParty1IDType) + ", submittingPartyIDType=" + String.valueOf(this.submittingPartyIDType) + ", usiIDPrefix=" + this.usiIDPrefix + ", utiIDPrefix=" + this.utiIDPrefix + ", submittedForParty=" + this.submittedForParty + ", tradeParty1ReportingDestination=" + String.valueOf(this.tradeParty1ReportingDestination) + ", tradeParty2ReportingDestination=" + String.valueOf(this.tradeParty2ReportingDestination) + ", primaryAssetClass=" + String.valueOf(this.primaryAssetClass) + ", comment1=" + this.comment1 + ", messageID=" + this.messageID + ", messageType=" + this.messageType + ", tradeParty2ExecutionAgentID=" + this.tradeParty2ExecutionAgentID + ", tradeParty2ExecutionAgentIDType=" + String.valueOf(this.tradeParty2ExecutionAgentIDType) + ", tradeParty1ExecutionAgentID=" + this.tradeParty1ExecutionAgentID + ", tradeParty1ExecutionAgentIDType=" + String.valueOf(this.tradeParty1ExecutionAgentIDType) + ", tradeParty1TransactionID=" + this.tradeParty1TransactionID + ", version=" + this.version + "}";
        }
    }
}

