/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir.contract.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.emir.contract.functions.GetMicDataForFacility;
import drr.regulation.common.emir.contract.functions.IsEmirTradingVenue;
import drr.regulation.common.emir.contract.functions.IsSI;
import drr.regulation.common.functions.GetIsin;
import drr.regulation.common.functions.GetTransactionInformationForRegime;
import drr.standards.iosco.cde.version3.datetime.reports.ExecutionTimestampRule;
import drr.standards.iso.MicData;
import drr.standards.iso.MicTypeEnum;
import java.time.LocalDate;
import javax.inject.Inject;

@ImplementedBy(value=ExecutionVenueDefault.class)
public abstract class ExecutionVenue
implements RosettaFunction {
    @Inject
    protected ExecutionTimestampRule executionTimestampRule;
    @Inject
    protected GetIsin getIsin;
    @Inject
    protected GetMicDataForFacility getMicDataForFacility;
    @Inject
    protected GetTransactionInformationForRegime getTransactionInformationForRegime;
    @Inject
    protected IsEmirTradingVenue isEmirTradingVenue;
    @Inject
    protected IsSI isSI;
    @Inject
    protected ProductForEvent productForEvent;

    public String evaluate(TransactionReportInstruction transaction, RegimeNameEnum regime) {
        String venue = this.doEvaluate(transaction, regime);
        return venue;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<? extends MicData> micDataForFacility(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<String> venueMic(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<Boolean> transactionHasIsin(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<? extends TransactionInformation> transactionInformation(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<Boolean> isinTotv(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<Boolean> uIsinTotv(TransactionReportInstruction var1, RegimeNameEnum var2);

    protected abstract MapperS<String> transactionValidMic(TransactionReportInstruction var1, RegimeNameEnum var2);

    public static class ExecutionVenueDefault
    extends ExecutionVenue {
        @Override
        protected String doEvaluate(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            String venue = null;
            return this.assignOutput(venue, transaction, regime);
        }

        protected String assignOutput(String venue, TransactionReportInstruction transaction, RegimeNameEnum regime) {
            venue = ExpressionOperatorsNullSafe.exists(this.transactionValidMic(transaction, regime)).getOrDefault(Boolean.valueOf(false)) != false ? (String)this.transactionValidMic(transaction, regime).get() : ((Boolean)this.isinTotv(transaction, regime).getOrDefault((Object)false) != false ? "XOFF" : "XXXX");
            return venue;
        }

        @Override
        protected MapperS<? extends MicData> micDataForFacility(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            return MapperS.of((Object)this.getMicDataForFacility.evaluate((ReportableInformation)MapperS.of((Object)transaction).map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).get()));
        }

        @Override
        protected MapperS<String> venueMic(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            MapperS<? extends MicData> thenArg = this.micDataForFacility(transaction, regime);
            return thenArg.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)item.map("getExpiryDate", micData -> micData.getExpiryDate()), (Mapper)MapperS.of((Object)this.executionTimestampRule.evaluate(transaction)).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getMicType", micData -> micData.getMicType()), (Mapper)MapperS.of((Object)((Object)MicTypeEnum.SGMT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getMic", micData -> micData.getMic());
                    }
                    return item.map("getOperatingMic", micData -> micData.getOperatingMic());
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected MapperS<Boolean> transactionHasIsin(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.getIsin.evaluate(this.productForEvent.evaluate(transaction)))).asMapper();
        }

        @Override
        protected MapperS<? extends TransactionInformation> transactionInformation(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)regime)), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.UKEMIR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.getTransactionInformationForRegime.evaluate(transaction, RegimeNameEnum.UKEMIR, SupervisoryBodyEnum.FCA));
            }
            return MapperS.of((Object)this.getTransactionInformationForRegime.evaluate(transaction, RegimeNameEnum.EMIR, SupervisoryBodyEnum.ESMA));
        }

        @Override
        protected MapperS<Boolean> isinTotv(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)regime)), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.UKEMIR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)ExpressionOperatorsNullSafe.areEqual((Mapper)this.transactionInformation(transaction, regime).map("getFcaTransactionInformation", _transactionInformation -> _transactionInformation.getFcaTransactionInformation()).map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), (Mapper)MapperS.of((Object)((Object)TradableOnTradingVenueEnum.ADMITTED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)));
            }
            return MapperS.of((Object)ExpressionOperatorsNullSafe.areEqual((Mapper)this.transactionInformation(transaction, regime).map("getEsmaTransactionInformation", _transactionInformation -> _transactionInformation.getEsmaTransactionInformation()).map("getTradableOnTradingVenue", eSMATransactionInformation -> eSMATransactionInformation.getTradableOnTradingVenue()), (Mapper)MapperS.of((Object)((Object)TradableOnTradingVenueEnum.ADMITTED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)));
        }

        @Override
        protected MapperS<Boolean> uIsinTotv(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)regime)), (Mapper)MapperS.of((Object)((Object)RegimeNameEnum.UKEMIR)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Boolean)this.transactionInformation(transaction, regime).map("getFcaTransactionInformation", _transactionInformation -> _transactionInformation.getFcaTransactionInformation()).map("getUnderlierTradedOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getUnderlierTradedOnTradingVenue()).getOrDefault((Object)false)));
            }
            return MapperS.of((Object)((Boolean)this.transactionInformation(transaction, regime).map("getEsmaTransactionInformation", _transactionInformation -> _transactionInformation.getEsmaTransactionInformation()).map("getUnderlierTradedOnTradingVenue", eSMATransactionInformation -> eSMATransactionInformation.getUnderlierTradedOnTradingVenue()).getOrDefault((Object)false)));
        }

        @Override
        protected MapperS<String> transactionValidMic(TransactionReportInstruction transaction, RegimeNameEnum regime) {
            if (ExpressionOperatorsNullSafe.exists(this.venueMic(transaction, regime)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                Boolean boolean0 = this.isEmirTradingVenue.evaluate((MicData)this.micDataForFacility(transaction, regime).get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return this.venueMic(transaction, regime);
                }
                Boolean boolean1 = this.isSI.evaluate((MicData)this.micDataForFacility(transaction, regime).get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    if (ComparisonResult.ofNullSafe(this.isinTotv(transaction, regime)).orNullSafe(ComparisonResult.ofNullSafe(this.uIsinTotv(transaction, regime))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return this.venueMic(transaction, regime);
                    }
                    return MapperS.of((Object)"XXXX");
                }
                return this.venueMic(transaction, regime);
            }
            return MapperS.ofNull();
        }
    }
}

