/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.base.qualification.product.functions.IsCommodity;
import drr.base.qualification.product.functions.IsEquity;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityRule;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=NotionalQuantityLeg2RuleDefault.class)
public abstract class NotionalQuantityLeg2Rule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected IsCommodity isCommodity;
    @Inject
    protected IsEquity isEquity;
    @Inject
    protected NotionalQuantityRule notionalQuantityRule;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;
    @Inject
    protected ProductForEvent productForEvent;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class NotionalQuantityLeg2RuleDefault
    extends NotionalQuantityLeg2Rule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEventBase)item.get()));
            MapperS ifThenElseResult = ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isEquity.evaluate(this.productForEvent.evaluate((ReportableEventBase)thenArg.get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommodity.evaluate(this.productForEvent.evaluate((ReportableEventBase)thenArg.get()))))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.notionalQuantityRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)thenArg.get()))) : MapperS.ofNull();
            output = (BigDecimal)ifThenElseResult.get();
            return output;
        }
    }
}

