/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.emir.reports.NameOfTheFloatingRateOfLeg2Rule;
import drr.regulation.common.emir.reports.SpreadOfLeg2NotationRule;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.standards.iosco.cde.version3.price.reports.SpreadRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadValueRule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SpreadOfLeg2RuleDefault.class)
public abstract class SpreadOfLeg2Rule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected NameOfTheFloatingRateOfLeg2Rule nameOfTheFloatingRateOfLeg2Rule;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;
    @Inject
    protected SpreadOfLeg2NotationRule spreadOfLeg2NotationRule;
    @Inject
    protected SpreadRule spreadRule;
    @Inject
    protected SpreadValueRule spreadValueRule;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class SpreadOfLeg2RuleDefault
    extends SpreadOfLeg2Rule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEventBase)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> {
                PriceSchedule priceSchedule = this.spreadRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)item.get()));
                if ((priceSchedule == null ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.ofNull()).getOrDefault(Boolean.valueOf(false)) : ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(Boolean.valueOf(false))).booleanValue()) {
                    return MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.spreadValueRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)item.get())), this.spreadOfLeg2NotationRule.evaluate((TransactionReportInstruction)item.get())));
                }
                String string = this.nameOfTheFloatingRateOfLeg2Rule.evaluate((TransactionReportInstruction)item.get());
                if ((string == null ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.ofNull()).getOrDefault(Boolean.valueOf(false)) : ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build())).getOrDefault(Boolean.valueOf(false))).booleanValue()) {
                    return MapperS.of((Object)PriceFormat.builder().setBasis(BigDecimal.valueOf(0L)).build());
                }
                return MapperS.ofNull();
            }).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

