/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityBasisLegWithNoSpreadDefault.class)
public abstract class CommodityBasisLegWithNoSpread
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public CommodityPayout evaluate(Product product) {
        CommodityPayout commodityPayout;
        CommodityPayout.CommodityPayoutBuilder commodityPayoutBuilder = this.doEvaluate(product);
        if (commodityPayoutBuilder == null) {
            commodityPayout = null;
        } else {
            commodityPayout = commodityPayoutBuilder.build();
            this.objectValidator.validate(CommodityPayout.class, (RosettaModelObject)commodityPayout);
        }
        return commodityPayout;
    }

    protected abstract CommodityPayout.CommodityPayoutBuilder doEvaluate(Product var1);

    public static class CommodityBasisLegWithNoSpreadDefault
    extends CommodityBasisLegWithNoSpread {
        @Override
        protected CommodityPayout.CommodityPayoutBuilder doEvaluate(Product product) {
            CommodityPayout.CommodityPayoutBuilder commodityPayout = CommodityPayout.builder();
            return this.assignOutput(commodityPayout, product);
        }

        protected CommodityPayout.CommodityPayoutBuilder assignOutput(CommodityPayout.CommodityPayoutBuilder commodityPayout, Product product) {
            MapperC thenArg = MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getCommodityPriceReturnTerms", _commodityPayout -> _commodityPayout.getCommodityPriceReturnTerms()).map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getCommodityPriceReturnTerms", _commodityPayout -> _commodityPayout.getCommodityPriceReturnTerms()).map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread()).map("getPrice", spreadSchedule -> spreadSchedule.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule -> referenceWithMetaPriceSchedule == null ? null : referenceWithMetaPriceSchedule.getValue()).map("getValue", priceSchedule -> priceSchedule.getValue()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All)).get());
            commodityPayout = (CommodityPayout.CommodityPayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((CommodityPayout)thenArg.get())).get());
            return Optional.ofNullable(commodityPayout).map(o -> o.prune()).orElse(null);
        }
    }
}

