/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomyClassification;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityFloatingPriceForward;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsCommoditySwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.functions.CommodityLeg1;
import javax.inject.Inject;

@ImplementedBy(value=ExtractCommodityClassificationLeg1Default.class)
public abstract class ExtractCommodityClassificationLeg1
implements RosettaFunction {
    @Inject
    protected CommodityLeg1 commodityLeg1;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsCommoditySwaption isCommoditySwaption;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public String evaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
        String commodityClassification = this.doEvaluate(product, taxonomySource, ordinal);
        return commodityClassification;
    }

    protected abstract String doEvaluate(Product var1, TaxonomySourceEnum var2, Integer var3);

    protected abstract MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(Product var1, TaxonomySourceEnum var2, Integer var3);

    protected abstract MapperC<? extends ProductTaxonomy> taxonomy(Product var1, TaxonomySourceEnum var2, Integer var3);

    public static class ExtractCommodityClassificationLeg1Default
    extends ExtractCommodityClassificationLeg1 {
        @Override
        protected String doEvaluate(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            String commodityClassification = null;
            return this.assignOutput(commodityClassification, product, taxonomySource, ordinal);
        }

        protected String assignOutput(String commodityClassification, Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            MapperC thenArg = MapperS.of((Object)((ProductTaxonomy)this.taxonomy(product, taxonomySource, ordinal).get())).map("getValue", productTaxonomy -> productTaxonomy.getValue()).mapC("getClassification", taxonomyValue -> taxonomyValue.getClassification()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getOrdinal", taxonomyClassification -> taxonomyClassification.getOrdinal()), (Mapper)MapperS.of((Object)ordinal), (CardinalityOperator)CardinalityOperator.All).get());
            commodityClassification = (String)MapperS.of((Object)((TaxonomyClassification)thenArg.get())).map("getValue", taxonomyClassification -> taxonomyClassification.getValue()).get();
            return commodityClassification;
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaCommodity> commodityUnderlier(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            Boolean boolean0 = this.qualify_Commodity_Option.evaluate(this.economicTermsForProduct.evaluate(product));
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getCommodity", _product -> _product.getCommodity());
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwaption.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.commodityLeg1.evaluate(this.underlierForProduct.evaluate(product))).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.commodityLeg1.evaluate(this.underlierForProduct.evaluate(product))).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity());
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwap.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.commodityLeg1.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.commodityLeg1.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity());
            }
            Boolean boolean1 = this.isCommodityFloatingPriceForward.evaluate(product);
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperS.of((Object)((CommodityPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperC<? extends ProductTaxonomy> taxonomy(Product product, TaxonomySourceEnum taxonomySource, Integer ordinal) {
            return this.commodityUnderlier(product, taxonomySource, ordinal).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductTaxonomy", commodity -> commodity.getProductTaxonomy()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSource", productTaxonomy -> productTaxonomy.getSource()), (Mapper)MapperS.of((Object)taxonomySource), (CardinalityOperator)CardinalityOperator.All).get());
        }
    }
}

