/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_InterestRate_Option_Swaption;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityFixedPriceForward;
import drr.base.qualification.product.functions.IsCommodityFloatingPriceForward;
import drr.base.qualification.product.functions.IsFXForward;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.qualification.product.functions.IsFXSwap;
import drr.base.trade.PayoutLeg;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.ReportableInformationBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.functions.CommodityBasisLegWithNoSpread;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.FXFarLeg;
import drr.regulation.common.functions.FXLeg2;
import drr.regulation.common.functions.FXSwapLeg2;
import drr.regulation.common.functions.FixedPriceLeg1;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.LastAvailableSpotPrice;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PayoutFromProductLeg2Default.class)
public abstract class PayoutFromProductLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityBasisLegWithNoSpread commodityBasisLegWithNoSpread;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FXFarLeg fXFarLeg;
    @Inject
    protected FXLeg2 fXLeg2;
    @Inject
    protected FXSwapLeg2 fXSwapLeg2;
    @Inject
    protected FixedPriceLeg1 fixedPriceLeg1;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsFXForward isFXForward;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected IsFXSwap isFXSwap;
    @Inject
    protected LastAvailableSpotPrice lastAvailableSpotPrice;
    @Inject
    protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
    @Inject
    protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_InterestRate_Option_Swaption qualify_InterestRate_Option_Swaption;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public PayoutLegWithAuxiliary evaluate(Product product, TradeLot tradeLot, ReportableInformationBase reportableInformation) {
        PayoutLegWithAuxiliary payoutLeg;
        PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLegBuilder = this.doEvaluate(product, tradeLot, reportableInformation);
        if (payoutLegBuilder == null) {
            payoutLeg = null;
        } else {
            payoutLeg = payoutLegBuilder.build();
            this.objectValidator.validate(PayoutLegWithAuxiliary.class, (RosettaModelObject)payoutLeg);
        }
        return payoutLeg;
    }

    protected abstract PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder doEvaluate(Product var1, TradeLot var2, ReportableInformationBase var3);

    protected abstract MapperS<? extends Payout> payout(Product var1, TradeLot var2, ReportableInformationBase var3);

    public static class PayoutFromProductLeg2Default
    extends PayoutFromProductLeg2 {
        @Override
        protected PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder doEvaluate(Product product, TradeLot tradeLot, ReportableInformationBase reportableInformation) {
            PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLeg = PayoutLegWithAuxiliary.builder();
            return this.assignOutput(payoutLeg, product, tradeLot, reportableInformation);
        }

        protected PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder assignOutput(PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder payoutLeg, Product product, TradeLot tradeLot, ReportableInformationBase reportableInformation) {
            Boolean boolean0 = this.qualify_InterestRate_Option_Swaption.evaluate(this.economicTermsForProduct.evaluate(product));
            if (boolean0 != null && boolean0.booleanValue()) {
                payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setInterestRatePayout(this.interestRateLeg2.evaluate(this.underlierForProduct.evaluate(product))).build());
            } else if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXForward.evaluate(product))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXOption.evaluate(product)))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setCashflow(this.fXLeg2.evaluate(product)).setZeroNotionalAmountDefaulting(true).build());
            } else {
                Boolean boolean1 = this.isFXSwap.evaluate(product);
                if (boolean1 != null && boolean1.booleanValue()) {
                    payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setCashflow(this.fXSwapLeg2.evaluate(product)).setSettlementTerms((SettlementTerms)MapperS.of((Object)this.fXFarLeg.evaluate(product)).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).get()).setZeroNotionalAmountDefaulting(true).build());
                } else {
                    Boolean boolean2 = this.qualify_Commodity_Swap_FixedFloat.evaluate(this.economicTermsForProduct.evaluate(product));
                    if (boolean2 != null && boolean2.booleanValue()) {
                        payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setCommodityPayout(this.commodityLeg2.evaluate(product)).setTradeLot(tradeLot).setAuxiliaryLeg(PayoutLeg.builder().setFixedPricePayout(this.fixedPriceLeg1.evaluate(product)).build()).build());
                    } else {
                        Boolean boolean3 = this.qualify_Commodity_Swap_Basis.evaluate(this.economicTermsForProduct.evaluate(product));
                        if (boolean3 != null && boolean3.booleanValue()) {
                            PayoutLeg ifThenElseResult0 = null;
                            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.lastAvailableSpotPrice.evaluate(reportableInformation))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                ifThenElseResult0 = PayoutLeg.builder().setCommodityPayout(this.commodityBasisLegWithNoSpread.evaluate(product)).build();
                            }
                            payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setCommodityPayout(this.commodityLeg2.evaluate(product)).setTradeLot(tradeLot).setLastAvailableSpotPrice(this.lastAvailableSpotPrice.evaluate(reportableInformation)).setAuxiliaryLeg(ifThenElseResult0).build());
                        } else {
                            Boolean boolean4 = this.isCommodityFixedPriceForward.evaluate(product);
                            if (boolean4 != null && boolean4.booleanValue()) {
                                payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setForwardPayout((ForwardPayout)this.payout(product, tradeLot, reportableInformation).mapC("getForwardPayout", _payout -> _payout.getForwardPayout()).get()).setAuxiliaryLeg(PayoutLeg.builder().setFixedPricePayout((FixedPricePayout)this.payout(product, tradeLot, reportableInformation).mapC("getFixedPricePayout", _payout -> _payout.getFixedPricePayout()).get()).build()).build());
                            } else {
                                Boolean boolean5 = this.isCommodityFloatingPriceForward.evaluate(product);
                                if (boolean5 != null && boolean5.booleanValue()) {
                                    payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setForwardPayout((ForwardPayout)this.payout(product, tradeLot, reportableInformation).mapC("getForwardPayout", _payout -> _payout.getForwardPayout()).get()).setAuxiliaryLeg(PayoutLeg.builder().setCommodityPayout((CommodityPayout)this.payout(product, tradeLot, reportableInformation).mapC("getCommodityPayout", _payout -> _payout.getCommodityPayout()).get()).build()).setTradeLot(tradeLot).setLastAvailableSpotPrice(this.lastAvailableSpotPrice.evaluate(reportableInformation)).build());
                                } else if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_InterestRate.evaluate(this.economicTermsForProduct.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(product))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Credit.evaluate(this.economicTermsForProduct.evaluate(product))))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                    PayoutLeg ifThenElseResult1 = null;
                                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)this.payout(product, tradeLot, reportableInformation).mapC("getFixedPricePayout", _payout -> _payout.getFixedPricePayout()).map("getPayerReceiver", fixedPricePayout -> fixedPricePayout.getPayerReceiver())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                                        ifThenElseResult1 = PayoutLeg.builder().setFixedPricePayout((FixedPricePayout)this.payout(product, tradeLot, reportableInformation).mapC("getFixedPricePayout", _payout -> _payout.getFixedPricePayout()).first().get()).build();
                                    }
                                    payoutLeg = (PayoutLegWithAuxiliary.PayoutLegWithAuxiliaryBuilder)this.toBuilder(PayoutLegWithAuxiliary.builder().setInterestRatePayout(this.interestRateLeg2.evaluate(product)).setAuxiliaryLeg(ifThenElseResult1).setSettlementTerms((SettlementTerms)MapperS.of((Object)((PerformancePayout)this.payout(product, tradeLot, reportableInformation).mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout()).get())).map("getSettlementTerms", performancePayout -> performancePayout.getSettlementTerms()).get()).build());
                                } else {
                                    payoutLeg = null;
                                }
                            }
                        }
                    }
                }
            }
            return Optional.ofNullable(payoutLeg).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Payout> payout(Product product, TradeLot tradeLot, ReportableInformationBase reportableInformation) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout());
        }
    }
}

