/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.index.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iso.functions.FormatToMax5Number;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=VersionRuleDefault.class)
public abstract class VersionRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FormatToMax5Number formatToMax5Number;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class VersionRuleDefault
    extends VersionRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEventBase)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate((Product)item.get()))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout());
                }
                return MapperS.ofNull();
            });
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> item.map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation()).map("getIndexAnnexVersion", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexAnnexVersion()));
            Integer integer = (Integer)thenArg2.get();
            output = (BigDecimal)MapperS.of((Object)this.formatToMax5Number.evaluate(integer == null ? null : BigDecimal.valueOf(integer.intValue()))).get();
            return output;
        }
    }
}

