/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.payment.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.payment.PeriodicPayment;
import drr.regulation.common.CommonAssetClass;
import drr.standards.iso.ActionTypeEnum;
import java.math.BigDecimal;

@ImplementedBy(value=DayCountConvLeg2Fixed_ValidationDefault.class)
public abstract class DayCountConvLeg2Fixed_Validation
implements RosettaFunction {
    public Boolean evaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, BigDecimal fixedRateLeg2, PeriodicPayment periodicPaymentLeg2) {
        Boolean result = this.doEvaluate(actionType, assetClass, fixedRateLeg2, periodicPaymentLeg2);
        return result;
    }

    protected abstract Boolean doEvaluate(ActionTypeEnum var1, CommonAssetClass var2, BigDecimal var3, PeriodicPayment var4);

    public static class DayCountConvLeg2Fixed_ValidationDefault
    extends DayCountConvLeg2Fixed_Validation {
        @Override
        protected Boolean doEvaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, BigDecimal fixedRateLeg2, PeriodicPayment periodicPaymentLeg2) {
            Boolean result = null;
            return this.assignOutput(result, actionType, assetClass, fixedRateLeg2, periodicPaymentLeg2);
        }

        protected Boolean assignOutput(Boolean result, ActionTypeEnum actionType, CommonAssetClass assetClass, BigDecimal fixedRateLeg2, PeriodicPayment periodicPaymentLeg2) {
            result = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)((Object)actionType)), (CardinalityOperator)CardinalityOperator.Any).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.INTR)), MapperS.of((Object)((Object)CommonAssetClass.CRDT)), MapperS.of((Object)((Object)CommonAssetClass.EQUI)), MapperS.of((Object)((Object)CommonAssetClass.COMM))}), (Mapper)MapperS.of((Object)((Object)assetClass)), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)fixedRateLeg2)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)periodicPaymentLeg2).map("getFixedRateDayCountConvention", periodicPayment -> periodicPayment.getFixedRateDayCountConvention())).get() : null) : null;
            return result;
        }
    }
}

