/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.payment.reports;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.standards.iso.functions.FormatToMax3Number;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=FloatingRateResetFrequencyPeriodMultiplierRuleDefault.class)
public abstract class FloatingRateResetFrequencyPeriodMultiplierRule
implements ReportFunction<InterestRatePayout, BigDecimal> {
    @Inject
    protected FormatToMax3Number formatToMax3Number;

    public BigDecimal evaluate(InterestRatePayout input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(InterestRatePayout var1);

    public static class FloatingRateResetFrequencyPeriodMultiplierRuleDefault
    extends FloatingRateResetFrequencyPeriodMultiplierRule {
        @Override
        protected BigDecimal doEvaluate(InterestRatePayout input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, InterestRatePayout input) {
            MapperS thenArg = MapperS.of((Object)input).map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).map("getResetFrequency", resetDates -> resetDates.getResetFrequency()).map("getPeriodMultiplier", resetFrequency -> resetFrequency.getPeriodMultiplier());
            Integer integer = (Integer)thenArg.get();
            output = (BigDecimal)MapperS.of((Object)this.formatToMax3Number.evaluate(integer == null ? null : BigDecimal.valueOf(integer.intValue()))).get();
            return output;
        }
    }
}

