/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.quantity.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ForwardPayout;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.quantity.functions.CommodityForwardObservablePriceQuantity;
import drr.base.trade.quantity.functions.CommodityObservablePriceQuantity;
import drr.base.trade.quantity.reports.CommodityFixedPriceQuantityRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityQuantityWithFrequencyDefault.class)
public abstract class CommodityQuantityWithFrequency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityFixedPriceQuantityRule commodityFixedPriceQuantityRule;
    @Inject
    protected CommodityForwardObservablePriceQuantity commodityForwardObservablePriceQuantity;
    @Inject
    protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;

    public NonNegativeQuantitySchedule evaluate(PayoutLegWithAuxiliary payout) {
        NonNegativeQuantitySchedule quantity;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityBuilder = this.doEvaluate(payout);
        if (quantityBuilder == null) {
            quantity = null;
        } else {
            quantity = quantityBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)quantity);
        }
        return quantity;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(PayoutLegWithAuxiliary var1);

    public static class CommodityQuantityWithFrequencyDefault
    extends CommodityQuantityWithFrequency {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(PayoutLegWithAuxiliary payout) {
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantity = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(quantity, payout);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantity, PayoutLegWithAuxiliary payout) {
            MapperC thenArg4;
            MapperS thenArg0 = MapperS.of((Object)this.commodityObservablePriceQuantity.evaluate((TradeLot)MapperS.of((Object)payout).map("getTradeLot", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getTradeLot()).get(), (CommodityPayout)MapperS.of((Object)payout).map("getCommodityPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getCommodityPayout()).get()));
            MapperS thenArg1 = MapperS.of((Object)((PriceQuantity)thenArg0.getOrDefault((Object)this.commodityFixedPriceQuantityRule.evaluate((TradeLot)MapperS.of((Object)payout).map("getTradeLot", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getTradeLot()).get()))));
            MapperS thenArg2 = MapperS.of((Object)((PriceQuantity)thenArg1.getOrDefault((Object)this.commodityForwardObservablePriceQuantity.evaluate((TradeLot)MapperS.of((Object)payout).map("getTradeLot", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getTradeLot()).get(), (ForwardPayout)MapperS.of((Object)payout).map("getForwardPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getForwardPayout()).get()))));
            MapperS thenArg3 = MapperS.of((Object)((PriceQuantity)thenArg2.getOrDefault((Object)((PriceQuantity)MapperS.of((Object)payout).map("getTradeLot", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).get()))));
            MapperS thenArg5 = MapperS.of((Object)((PriceQuantity)thenArg3.getOrDefault((Object)((PriceQuantity)MapperS.of((Object)((PriceQuantity)(thenArg4 = MapperS.of((Object)payout).map("getTradeLot", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).filterItemNullSafe(pq -> ExpressionOperatorsNullSafe.exists((Mapper)pq.mapC("getPrice", priceQuantity -> priceQuantity.getPrice())).get())).get())).get()))));
            MapperC thenArg6 = thenArg5.mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule2 -> fieldWithMetaNonNegativeQuantitySchedule2 == null ? null : fieldWithMetaNonNegativeQuantitySchedule2.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All))).get());
            FieldWithMetaNonNegativeQuantitySchedule fieldWithMetaNonNegativeQuantitySchedule = (FieldWithMetaNonNegativeQuantitySchedule)MapperS.of((Object)((FieldWithMetaNonNegativeQuantitySchedule)thenArg6.get())).get();
            quantity = fieldWithMetaNonNegativeQuantitySchedule == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder((RosettaModelObject)fieldWithMetaNonNegativeQuantitySchedule.getValue());
            return Optional.ofNullable(quantity).map(o -> o.prune()).orElse(null);
        }
    }
}

