/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.payment.PeriodicPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.quantity.NotionalPeriod;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.regulation.csa.rewrite.trade.meta.CSALegMeta;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CSALeg", builder=CSALegBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="CSALeg", model="drr", builder=CSALegBuilderImpl.class, version="7.0.0-dev.92")
public interface CSALeg
extends CommonLeg {
    public static final CSALegMeta metaData = new CSALegMeta();

    public String getUnderlierIDOther();

    public String getUnderlierIDOtherSource();

    public String getUnderlyingAssetTradingPlatformIdentifier();

    public String getUnderlyingAssetPriceSource();

    public Boolean getCryptoAssetUnderlyingIndicator();

    public String getCommodityUnderlyerID();

    public String getCommodityInstrumentID();

    public String getFloatingRateIndex();

    @Override
    public CSALeg build();

    @Override
    public CSALegBuilder toBuilder();

    public static CSALegBuilder builder() {
        return new CSALegBuilderImpl();
    }

    default public RosettaMetaData<? extends CSALeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CSALeg> getType() {
        return CSALeg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodicPayment"), processor, CommonPeriodicPayment.class, this.getPeriodicPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.class, this.getSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalQuantity"), BigDecimal.class, (Object)this.getNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequency"), FrequencyPeriodEnum.class, (Object)this.getQuantityFrequency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityFrequencyMultiplier"), Integer.class, (Object)this.getQuantityFrequencyMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("payerIdentifier"), String.class, (Object)this.getPayerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("receiverIdentifier"), String.class, (Object)this.getReceiverIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), Date.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlierIDOther"), String.class, (Object)this.getUnderlierIDOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlierIDOtherSource"), String.class, (Object)this.getUnderlierIDOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("commodityUnderlyerID"), String.class, (Object)this.getCommodityUnderlyerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("commodityInstrumentID"), String.class, (Object)this.getCommodityInstrumentID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateIndex"), String.class, (Object)this.getFloatingRateIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CSALegBuilderImpl
    extends CommonLeg.CommonLegBuilderImpl
    implements CSALegBuilder {
        protected String underlierIDOther;
        protected String underlierIDOtherSource;
        protected String underlyingAssetTradingPlatformIdentifier;
        protected String underlyingAssetPriceSource;
        protected Boolean cryptoAssetUnderlyingIndicator;
        protected String commodityUnderlyerID;
        protected String commodityInstrumentID;
        protected String floatingRateIndex;

        @Override
        @RosettaAttribute(value="underlierIDOther")
        @RuneAttribute(value="underlierIDOther")
        public String getUnderlierIDOther() {
            return this.underlierIDOther;
        }

        @Override
        @RosettaAttribute(value="underlierIDOtherSource")
        @RuneAttribute(value="underlierIDOtherSource")
        public String getUnderlierIDOtherSource() {
            return this.underlierIDOtherSource;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public String getUnderlyingAssetTradingPlatformIdentifier() {
            return this.underlyingAssetTradingPlatformIdentifier;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public String getUnderlyingAssetPriceSource() {
            return this.underlyingAssetPriceSource;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public Boolean getCryptoAssetUnderlyingIndicator() {
            return this.cryptoAssetUnderlyingIndicator;
        }

        @Override
        @RosettaAttribute(value="commodityUnderlyerID")
        @RuneAttribute(value="commodityUnderlyerID")
        public String getCommodityUnderlyerID() {
            return this.commodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="commodityInstrumentID")
        @RuneAttribute(value="commodityInstrumentID")
        public String getCommodityInstrumentID() {
            return this.commodityInstrumentID;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex")
        @RuneAttribute(value="floatingRateIndex")
        public String getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public CSALegBuilder setPeriodicPayment(CommonPeriodicPayment _periodicPayment) {
            this.periodicPayment = _periodicPayment == null ? null : _periodicPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public CSALegBuilder setPeriodicPayment(PeriodicPayment _periodicPayment) {
            CommonPeriodicPayment ifThenElseResult = _periodicPayment == null ? null : (_periodicPayment instanceof CommonPeriodicPayment ? (CommonPeriodicPayment)CommonPeriodicPayment.class.cast(_periodicPayment) : null);
            return this.setPeriodicPayment(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public CSALegBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public CSALegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule) {
            if (_notionalAmountSchedule != null) {
                this.notionalAmountSchedule.add(_notionalAmountSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CSALegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule, int idx) {
            this.getIndex(this.notionalAmountSchedule, idx, () -> _notionalAmountSchedule.toBuilder());
            return this;
        }

        @Override
        public CSALegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            if (notionalAmountSchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalAmountSchedules) {
                    this.notionalAmountSchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountSchedule")
        public CSALegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            this.notionalAmountSchedule = notionalAmountSchedules == null ? new ArrayList() : (List)notionalAmountSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public CSALegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule) {
            if (_notionalQuantitySchedule != null) {
                this.notionalQuantitySchedule.add(_notionalQuantitySchedule.toBuilder());
            }
            return this;
        }

        @Override
        public CSALegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule, int idx) {
            this.getIndex(this.notionalQuantitySchedule, idx, () -> _notionalQuantitySchedule.toBuilder());
            return this;
        }

        @Override
        public CSALegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            if (notionalQuantitySchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalQuantitySchedules) {
                    this.notionalQuantitySchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantitySchedule")
        public CSALegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            this.notionalQuantitySchedule = notionalQuantitySchedules == null ? new ArrayList() : (List)notionalQuantitySchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public CSALegBuilder setNotionalCurrency(ISOCurrencyCodeEnum _notionalCurrency) {
            this.notionalCurrency = _notionalCurrency == null ? null : _notionalCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public CSALegBuilder setTotalNotionalQuantity(BigDecimal _totalNotionalQuantity) {
            this.totalNotionalQuantity = _totalNotionalQuantity == null ? null : _totalNotionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public CSALegBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public CSALegBuilder setSettlementCurrency(ISOCurrencyCodeEnum _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public CSALegBuilder setSpread(PriceFormat _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public CSALegBuilder setSpreadNotation(PriceNotationEnum _spreadNotation) {
            this.spreadNotation = _spreadNotation == null ? null : _spreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public CSALegBuilder setSpreadCurrency(ISOCurrencyCodeEnum _spreadCurrency) {
            this.spreadCurrency = _spreadCurrency == null ? null : _spreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public CSALegBuilder setQuantityUnitOfMeasure(String _quantityUnitOfMeasure) {
            this.quantityUnitOfMeasure = _quantityUnitOfMeasure == null ? null : _quantityUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public CSALegBuilder setDirection2(Direction2Enum _direction2) {
            this.direction2 = _direction2 == null ? null : _direction2;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantity")
        @RuneAttribute(value="notionalQuantity")
        public CSALegBuilder setNotionalQuantity(BigDecimal _notionalQuantity) {
            this.notionalQuantity = _notionalQuantity == null ? null : _notionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate")
        @RuneAttribute(value="fixingDate")
        public CSALegBuilder setFixingDate(ZonedDateTime _fixingDate) {
            this.fixingDate = _fixingDate == null ? null : _fixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequency")
        @RuneAttribute(value="quantityFrequency")
        public CSALegBuilder setQuantityFrequency(FrequencyPeriodEnum _quantityFrequency) {
            this.quantityFrequency = _quantityFrequency == null ? null : _quantityFrequency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityFrequencyMultiplier")
        @RuneAttribute(value="quantityFrequencyMultiplier")
        public CSALegBuilder setQuantityFrequencyMultiplier(Integer _quantityFrequencyMultiplier) {
            this.quantityFrequencyMultiplier = _quantityFrequencyMultiplier == null ? null : _quantityFrequencyMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerIdentifier")
        @RuneAttribute(value="payerIdentifier")
        public CSALegBuilder setPayerIdentifier(String _payerIdentifier) {
            this.payerIdentifier = _payerIdentifier == null ? null : _payerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="receiverIdentifier")
        @RuneAttribute(value="receiverIdentifier")
        public CSALegBuilder setReceiverIdentifier(String _receiverIdentifier) {
            this.receiverIdentifier = _receiverIdentifier == null ? null : _receiverIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public CSALegBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDate")
        @RuneAttribute(value="nextFloatingReferenceResetDate")
        public CSALegBuilder setNextFloatingReferenceResetDate(Date _nextFloatingReferenceResetDate) {
            this.nextFloatingReferenceResetDate = _nextFloatingReferenceResetDate == null ? null : _nextFloatingReferenceResetDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlierIDOther")
        @RuneAttribute(value="underlierIDOther")
        public CSALegBuilder setUnderlierIDOther(String _underlierIDOther) {
            this.underlierIDOther = _underlierIDOther == null ? null : _underlierIDOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlierIDOtherSource")
        @RuneAttribute(value="underlierIDOtherSource")
        public CSALegBuilder setUnderlierIDOtherSource(String _underlierIDOtherSource) {
            this.underlierIDOtherSource = _underlierIDOtherSource == null ? null : _underlierIDOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public CSALegBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public CSALegBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public CSALegBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityUnderlyerID")
        @RuneAttribute(value="commodityUnderlyerID")
        public CSALegBuilder setCommodityUnderlyerID(String _commodityUnderlyerID) {
            this.commodityUnderlyerID = _commodityUnderlyerID == null ? null : _commodityUnderlyerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="commodityInstrumentID")
        @RuneAttribute(value="commodityInstrumentID")
        public CSALegBuilder setCommodityInstrumentID(String _commodityInstrumentID) {
            this.commodityInstrumentID = _commodityInstrumentID == null ? null : _commodityInstrumentID;
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex")
        @RuneAttribute(value="floatingRateIndex")
        public CSALegBuilder setFloatingRateIndex(String _floatingRateIndex) {
            this.floatingRateIndex = _floatingRateIndex == null ? null : _floatingRateIndex;
            return this;
        }

        @Override
        public CSALeg build() {
            return new CSALegImpl(this);
        }

        @Override
        public CSALegBuilder toBuilder() {
            return this;
        }

        @Override
        public CSALegBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getUnderlierIDOther() != null) {
                return true;
            }
            if (this.getUnderlierIDOtherSource() != null) {
                return true;
            }
            if (this.getUnderlyingAssetTradingPlatformIdentifier() != null) {
                return true;
            }
            if (this.getUnderlyingAssetPriceSource() != null) {
                return true;
            }
            if (this.getCryptoAssetUnderlyingIndicator() != null) {
                return true;
            }
            if (this.getCommodityUnderlyerID() != null) {
                return true;
            }
            if (this.getCommodityInstrumentID() != null) {
                return true;
            }
            return this.getFloatingRateIndex() != null;
        }

        @Override
        public CSALegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CSALegBuilder o = (CSALegBuilder)other;
            merger.mergeBasic((Object)this.getUnderlierIDOther(), (Object)o.getUnderlierIDOther(), this::setUnderlierIDOther, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlierIDOtherSource(), (Object)o.getUnderlierIDOtherSource(), this::setUnderlierIDOtherSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (Object)o.getUnderlyingAssetTradingPlatformIdentifier(), this::setUnderlyingAssetTradingPlatformIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUnderlyingAssetPriceSource(), (Object)o.getUnderlyingAssetPriceSource(), this::setUnderlyingAssetPriceSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCryptoAssetUnderlyingIndicator(), (Object)o.getCryptoAssetUnderlyingIndicator(), this::setCryptoAssetUnderlyingIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCommodityUnderlyerID(), (Object)o.getCommodityUnderlyerID(), this::setCommodityUnderlyerID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCommodityInstrumentID(), (Object)o.getCommodityInstrumentID(), this::setCommodityInstrumentID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateIndex(), (Object)o.getFloatingRateIndex(), this::setFloatingRateIndex, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CSALeg _that = (CSALeg)this.getType().cast(o);
            if (!Objects.equals(this.underlierIDOther, _that.getUnderlierIDOther())) {
                return false;
            }
            if (!Objects.equals(this.underlierIDOtherSource, _that.getUnderlierIDOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetTradingPlatformIdentifier, _that.getUnderlyingAssetTradingPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) {
                return false;
            }
            if (!Objects.equals(this.cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) {
                return false;
            }
            if (!Objects.equals(this.commodityUnderlyerID, _that.getCommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.commodityInstrumentID, _that.getCommodityInstrumentID())) {
                return false;
            }
            return Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlierIDOther != null ? this.underlierIDOther.hashCode() : 0);
            _result = 31 * _result + (this.underlierIDOtherSource != null ? this.underlierIDOtherSource.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetTradingPlatformIdentifier != null ? this.underlyingAssetTradingPlatformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetPriceSource != null ? this.underlyingAssetPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.cryptoAssetUnderlyingIndicator != null ? this.cryptoAssetUnderlyingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.commodityUnderlyerID != null ? this.commodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.commodityInstrumentID != null ? this.commodityInstrumentID.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CSALegBuilder {underlierIDOther=" + this.underlierIDOther + ", underlierIDOtherSource=" + this.underlierIDOtherSource + ", underlyingAssetTradingPlatformIdentifier=" + this.underlyingAssetTradingPlatformIdentifier + ", underlyingAssetPriceSource=" + this.underlyingAssetPriceSource + ", cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", commodityUnderlyerID=" + this.commodityUnderlyerID + ", commodityInstrumentID=" + this.commodityInstrumentID + ", floatingRateIndex=" + this.floatingRateIndex + "} " + super.toString();
        }
    }

    public static interface CSALegBuilder
    extends CSALeg,
    CommonLeg.CommonLegBuilder {
        @Override
        public CSALegBuilder setPeriodicPayment(PeriodicPayment var1);

        @Override
        public CSALegBuilder setNotionalAmount(BigDecimal var1);

        @Override
        public CSALegBuilder addNotionalAmountSchedule(NotionalPeriod var1);

        @Override
        public CSALegBuilder addNotionalAmountSchedule(NotionalPeriod var1, int var2);

        @Override
        public CSALegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CSALegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CSALegBuilder addNotionalQuantitySchedule(NotionalPeriod var1);

        @Override
        public CSALegBuilder addNotionalQuantitySchedule(NotionalPeriod var1, int var2);

        @Override
        public CSALegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CSALegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public CSALegBuilder setNotionalCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSALegBuilder setTotalNotionalQuantity(BigDecimal var1);

        @Override
        public CSALegBuilder setFixedRate(BigDecimal var1);

        @Override
        public CSALegBuilder setSettlementCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSALegBuilder setSpread(PriceFormat var1);

        @Override
        public CSALegBuilder setSpreadNotation(PriceNotationEnum var1);

        @Override
        public CSALegBuilder setSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CSALegBuilder setQuantityUnitOfMeasure(String var1);

        @Override
        public CSALegBuilder setDirection2(Direction2Enum var1);

        @Override
        public CSALegBuilder setPeriodicPayment(CommonPeriodicPayment var1);

        @Override
        public CSALegBuilder setNotionalQuantity(BigDecimal var1);

        @Override
        public CSALegBuilder setFixingDate(ZonedDateTime var1);

        @Override
        public CSALegBuilder setQuantityFrequency(FrequencyPeriodEnum var1);

        @Override
        public CSALegBuilder setQuantityFrequencyMultiplier(Integer var1);

        @Override
        public CSALegBuilder setPayerIdentifier(String var1);

        @Override
        public CSALegBuilder setReceiverIdentifier(String var1);

        @Override
        public CSALegBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public CSALegBuilder setNextFloatingReferenceResetDate(Date var1);

        public CSALegBuilder setUnderlierIDOther(String var1);

        public CSALegBuilder setUnderlierIDOtherSource(String var1);

        public CSALegBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        public CSALegBuilder setUnderlyingAssetPriceSource(String var1);

        public CSALegBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        public CSALegBuilder setCommodityUnderlyerID(String var1);

        public CSALegBuilder setCommodityInstrumentID(String var1);

        public CSALegBuilder setFloatingRateIndex(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodicPayment"), processor, CommonPeriodicPayment.CommonPeriodicPaymentBuilder.class, (RosettaModelObjectBuilder)this.getPeriodicPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalQuantity"), BigDecimal.class, (Object)this.getNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequency"), FrequencyPeriodEnum.class, (Object)this.getQuantityFrequency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityFrequencyMultiplier"), Integer.class, (Object)this.getQuantityFrequencyMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("payerIdentifier"), String.class, (Object)this.getPayerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("receiverIdentifier"), String.class, (Object)this.getReceiverIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDate"), Date.class, (Object)this.getNextFloatingReferenceResetDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlierIDOther"), String.class, (Object)this.getUnderlierIDOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlierIDOtherSource"), String.class, (Object)this.getUnderlierIDOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("commodityUnderlyerID"), String.class, (Object)this.getCommodityUnderlyerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("commodityInstrumentID"), String.class, (Object)this.getCommodityInstrumentID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateIndex"), String.class, (Object)this.getFloatingRateIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CSALegBuilder prune();
    }

    public static class CSALegImpl
    extends CommonLeg.CommonLegImpl
    implements CSALeg {
        private final String underlierIDOther;
        private final String underlierIDOtherSource;
        private final String underlyingAssetTradingPlatformIdentifier;
        private final String underlyingAssetPriceSource;
        private final Boolean cryptoAssetUnderlyingIndicator;
        private final String commodityUnderlyerID;
        private final String commodityInstrumentID;
        private final String floatingRateIndex;

        protected CSALegImpl(CSALegBuilder builder) {
            super(builder);
            this.underlierIDOther = builder.getUnderlierIDOther();
            this.underlierIDOtherSource = builder.getUnderlierIDOtherSource();
            this.underlyingAssetTradingPlatformIdentifier = builder.getUnderlyingAssetTradingPlatformIdentifier();
            this.underlyingAssetPriceSource = builder.getUnderlyingAssetPriceSource();
            this.cryptoAssetUnderlyingIndicator = builder.getCryptoAssetUnderlyingIndicator();
            this.commodityUnderlyerID = builder.getCommodityUnderlyerID();
            this.commodityInstrumentID = builder.getCommodityInstrumentID();
            this.floatingRateIndex = builder.getFloatingRateIndex();
        }

        @Override
        @RosettaAttribute(value="underlierIDOther")
        @RuneAttribute(value="underlierIDOther")
        public String getUnderlierIDOther() {
            return this.underlierIDOther;
        }

        @Override
        @RosettaAttribute(value="underlierIDOtherSource")
        @RuneAttribute(value="underlierIDOtherSource")
        public String getUnderlierIDOtherSource() {
            return this.underlierIDOtherSource;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public String getUnderlyingAssetTradingPlatformIdentifier() {
            return this.underlyingAssetTradingPlatformIdentifier;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public String getUnderlyingAssetPriceSource() {
            return this.underlyingAssetPriceSource;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public Boolean getCryptoAssetUnderlyingIndicator() {
            return this.cryptoAssetUnderlyingIndicator;
        }

        @Override
        @RosettaAttribute(value="commodityUnderlyerID")
        @RuneAttribute(value="commodityUnderlyerID")
        public String getCommodityUnderlyerID() {
            return this.commodityUnderlyerID;
        }

        @Override
        @RosettaAttribute(value="commodityInstrumentID")
        @RuneAttribute(value="commodityInstrumentID")
        public String getCommodityInstrumentID() {
            return this.commodityInstrumentID;
        }

        @Override
        @RosettaAttribute(value="floatingRateIndex")
        @RuneAttribute(value="floatingRateIndex")
        public String getFloatingRateIndex() {
            return this.floatingRateIndex;
        }

        @Override
        public CSALeg build() {
            return this;
        }

        @Override
        public CSALegBuilder toBuilder() {
            CSALegBuilder builder = CSALeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CSALegBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getUnderlierIDOther()).ifPresent(builder::setUnderlierIDOther);
            Optional.ofNullable(this.getUnderlierIDOtherSource()).ifPresent(builder::setUnderlierIDOtherSource);
            Optional.ofNullable(this.getUnderlyingAssetTradingPlatformIdentifier()).ifPresent(builder::setUnderlyingAssetTradingPlatformIdentifier);
            Optional.ofNullable(this.getUnderlyingAssetPriceSource()).ifPresent(builder::setUnderlyingAssetPriceSource);
            Optional.ofNullable(this.getCryptoAssetUnderlyingIndicator()).ifPresent(builder::setCryptoAssetUnderlyingIndicator);
            Optional.ofNullable(this.getCommodityUnderlyerID()).ifPresent(builder::setCommodityUnderlyerID);
            Optional.ofNullable(this.getCommodityInstrumentID()).ifPresent(builder::setCommodityInstrumentID);
            Optional.ofNullable(this.getFloatingRateIndex()).ifPresent(builder::setFloatingRateIndex);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CSALeg _that = (CSALeg)this.getType().cast(o);
            if (!Objects.equals(this.underlierIDOther, _that.getUnderlierIDOther())) {
                return false;
            }
            if (!Objects.equals(this.underlierIDOtherSource, _that.getUnderlierIDOtherSource())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetTradingPlatformIdentifier, _that.getUnderlyingAssetTradingPlatformIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.underlyingAssetPriceSource, _that.getUnderlyingAssetPriceSource())) {
                return false;
            }
            if (!Objects.equals(this.cryptoAssetUnderlyingIndicator, _that.getCryptoAssetUnderlyingIndicator())) {
                return false;
            }
            if (!Objects.equals(this.commodityUnderlyerID, _that.getCommodityUnderlyerID())) {
                return false;
            }
            if (!Objects.equals(this.commodityInstrumentID, _that.getCommodityInstrumentID())) {
                return false;
            }
            return Objects.equals(this.floatingRateIndex, _that.getFloatingRateIndex());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlierIDOther != null ? this.underlierIDOther.hashCode() : 0);
            _result = 31 * _result + (this.underlierIDOtherSource != null ? this.underlierIDOtherSource.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetTradingPlatformIdentifier != null ? this.underlyingAssetTradingPlatformIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.underlyingAssetPriceSource != null ? this.underlyingAssetPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.cryptoAssetUnderlyingIndicator != null ? this.cryptoAssetUnderlyingIndicator.hashCode() : 0);
            _result = 31 * _result + (this.commodityUnderlyerID != null ? this.commodityUnderlyerID.hashCode() : 0);
            _result = 31 * _result + (this.commodityInstrumentID != null ? this.commodityInstrumentID.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateIndex != null ? this.floatingRateIndex.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CSALeg {underlierIDOther=" + this.underlierIDOther + ", underlierIDOtherSource=" + this.underlierIDOtherSource + ", underlyingAssetTradingPlatformIdentifier=" + this.underlyingAssetTradingPlatformIdentifier + ", underlyingAssetPriceSource=" + this.underlyingAssetPriceSource + ", cryptoAssetUnderlyingIndicator=" + this.cryptoAssetUnderlyingIndicator + ", commodityUnderlyerID=" + this.commodityUnderlyerID + ", commodityInstrumentID=" + this.commodityInstrumentID + ", floatingRateIndex=" + this.floatingRateIndex + "} " + super.toString();
        }
    }
}

