/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import cdm.base.math.Measure;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.quantity.functions.CurrencyFromNotional;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.functions.PayoutForQuantityLeg2;
import drr.standards.iosco.cde.version3.quantity.functions.Notional;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrencyLeg2RuleDefault.class)
public abstract class NotionalCurrencyLeg2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CurrencyFromNotional currencyFromNotional;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected Notional notional;
    @Inject
    protected PayoutForQuantityLeg2 payoutForQuantityLeg2;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrencyLeg2RuleDefault
    extends NotionalCurrencyLeg2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEventBase)item.get()));
            MapperS thenArg1 = MapperS.of((Object)this.notional.evaluate(this.payoutForQuantityLeg2.evaluate((TransactionReportInstruction)thenArg0.get())));
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)this.currencyFromNotional.evaluate((Measure)thenArg1.get())).get();
            return output;
        }
    }
}

