/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.reports.PackageTransactionPriceNotationRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceValueRule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionPriceRuleDefault.class)
public abstract class PackageTransactionPriceRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
    @Inject
    protected PackageTransactionPriceValueRule packageTransactionPriceValueRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionPriceRuleDefault
    extends PackageTransactionPriceRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEventBase)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.packageTransactionPriceValueRule.evaluate((TransactionReportInstructionBase)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.packageTransactionPriceValueRule.evaluate((TransactionReportInstructionBase)item.get()), this.packageTransactionPriceNotationRule.evaluate((TransactionReportInstruction)item.get())));
                }
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.packageTransactionPriceNotationRule.evaluate((TransactionReportInstruction)item.get()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)PriceFormat.builder().setMonetary(new BigDecimal("99999.9999999999999")).build());
                }
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.packageTransactionPriceNotationRule.evaluate((TransactionReportInstruction)item.get()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.DECIMAL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)PriceFormat.builder().setDecimal(new BigDecimal("9.9999999999")).build());
                }
                return MapperS.ofNull();
            }).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

