/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.emir.contract.functions.ExecutionISIN;
import javax.inject.Inject;

@ImplementedBy(value=ISINRuleDefault.class)
public abstract class ISINRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected ExecutionISIN executionISIN;
    @Inject
    protected IsAllowableAction isAllowableAction;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class ISINRuleDefault
    extends ISINRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEventBase)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.executionISIN.evaluate((TransactionReportInstruction)item.get(), RegimeNameEnum.EMIR))).get();
            return output;
        }
    }
}

