/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.valuation.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.valuation.FCAValuationReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class FCAValuationReportTypeFormatValidator
implements Validator<FCAValuationReport> {
    private List<ComparisonResult> getComparisonResults(FCAValuationReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkNumber((String)"valuationAmount", (BigDecimal)o.getValuationAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"delta", (BigDecimal)o.getDelta(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"entityResponsibleForReporting", (String)o.getEntityResponsibleForReporting(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2IdentifierSource", (String)o.getCounterparty2IdentifierSource(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"uniqueTransactionIdentifier", (String)o.getUniqueTransactionIdentifier(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9]{0,32}"))), ExpressionOperatorsNullSafe.checkString((String)"uniqueTransactionIdentifierProprietary", (String)o.getUniqueTransactionIdentifierProprietary(), (int)0, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1}[a-zA-Z0-9\\:.\\-_]{0,50}[a-zA-Z0-9]{1}"))), ExpressionOperatorsNullSafe.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkNumber((String)"lastFloatingReferenceValueLeg1", (BigDecimal)o.getLastFloatingReferenceValueLeg1(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"lastFloatingReferenceValueLeg2", (BigDecimal)o.getLastFloatingReferenceValueLeg2(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty())});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAValuationReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"FCAValuationReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"FCAValuationReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"FCAValuationReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"FCAValuationReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

