/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.margin.validation.datarule;

import cdm.base.datetime.functions.Now;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.margin.HKMAMarginReport;
import drr.standards.iso.MarginActionEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="HKMAMarginReportDOC0011")
@ImplementedBy(value=Default.class)
public interface HKMAMarginReportDOC0011
extends Validator<HKMAMarginReport> {
    public static final String NAME = "HKMAMarginReportDOC0011";
    public static final String DEFINITION = "if [MarginActionEnum -> MARU, MarginActionEnum -> CORR] any = actionType then reportingTimestamp <= Now";

    public static class NoOp
    implements HKMAMarginReportDOC0011 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAMarginReport hKMAMarginReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements HKMAMarginReportDOC0011 {
        @Inject
        protected Now now;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMAMarginReport hKMAMarginReport) {
            ComparisonResult result = this.executeDataRule(hKMAMarginReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)HKMAMarginReportDOC0011.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMAMarginReport", (RosettaPath)path, (String)HKMAMarginReportDOC0011.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)HKMAMarginReportDOC0011.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMAMarginReport", (RosettaPath)path, (String)HKMAMarginReportDOC0011.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(HKMAMarginReport hKMAMarginReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)MarginActionEnum.MARU)), MapperS.of((Object)((Object)MarginActionEnum.CORR))}), (Mapper)MapperS.of((Object)hKMAMarginReport).map("getActionType", _hKMAMarginReport -> _hKMAMarginReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)hKMAMarginReport).map("getReportingTimestamp", _hKMAMarginReport -> _hKMAMarginReport.getReportingTimestamp()), (Mapper)MapperS.of((Object)this.now.evaluate()), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

