/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.quantity.NotionalPeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.version3.quantity.reports.NotionalAmountScheduleRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=NotionalAmountScheduleLeg2RuleDefault.class)
public abstract class NotionalAmountScheduleLeg2Rule
implements ReportFunction<TransactionReportInstruction, List<? extends NotionalPeriod>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsAllowableActionForJFSA isAllowableActionForJFSA;
    @Inject
    protected NotionalAmountScheduleRule notionalAmountScheduleRule;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;

    public List<? extends NotionalPeriod> evaluate(TransactionReportInstruction input) {
        List output;
        List<NotionalPeriod.NotionalPeriodBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(NotionalPeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(NotionalPeriod.class, output);
        }
        return output;
    }

    protected abstract List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class NotionalAmountScheduleLeg2RuleDefault
    extends NotionalAmountScheduleLeg2Rule {
        @Override
        protected List<NotionalPeriod.NotionalPeriodBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<NotionalPeriod.NotionalPeriodBuilder> output = new ArrayList<NotionalPeriod.NotionalPeriodBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<NotionalPeriod.NotionalPeriodBuilder> assignOutput(List<NotionalPeriod.NotionalPeriodBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForJFSA.evaluate((ReportableEventBase)item.get()));
            output = this.toBuilder(MapperC.of(this.notionalAmountScheduleRule.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)thenArg.get()))).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

