/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.valuation.datetime.reports.ReportingTimestampRule;
import drr.regulation.common.valuation.datetime.reports.ValuationTimestampRule;
import drr.regulation.common.valuation.event.reports.ActionTypeRule;
import drr.regulation.common.valuation.party.reports.Counterparty1Rule;
import drr.regulation.common.valuation.party.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.common.valuation.party.reports.Counterparty2Rule;
import drr.regulation.common.valuation.party.reports.EntityResponsibleForReportingRule;
import drr.regulation.common.valuation.party.reports.ReportSubmittingEntityIDRule;
import drr.regulation.common.valuation.quantity.reports.DeltaRule;
import drr.regulation.common.valuation.valuation.reports.ValuationAmountRule;
import drr.regulation.common.valuation.valuation.reports.ValuationCurrencyRule;
import drr.regulation.common.valuation.valuation.reports.ValuationMethodRule;
import drr.regulation.jfsa.rewrite.valuation.JFSAValuationReport;
import drr.regulation.jfsa.rewrite.valuation.labels.JFSAValuationLabelProvider;
import drr.regulation.jfsa.rewrite.valuation.reports.NewSDRIdentifierRule;
import drr.regulation.jfsa.rewrite.valuation.reports.TechnicalRecordIdRule;
import drr.regulation.jfsa.rewrite.valuation.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.jfsa.rewrite.valuation.reports.UniqueTransactionIdentifierRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.jfsa.rewrite.valuation", body="JFSA", corpusList={"Valuation"})
@RuneLabelProvider(labelProvider=JFSAValuationLabelProvider.class)
@ImplementedBy(value=JFSAValuationReportFunctionDefault.class)
public abstract class JFSAValuationReportFunction
implements ReportFunction<ValuationReportInstruction, JFSAValuationReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected DeltaRule deltaRule;
    @Inject
    protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
    @Inject
    protected NewSDRIdentifierRule newSDRIdentifierRule;
    @Inject
    protected ReportSubmittingEntityIDRule reportSubmittingEntityIDRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;

    public JFSAValuationReport evaluate(ValuationReportInstruction input) {
        JFSAValuationReport output;
        JFSAValuationReport.JFSAValuationReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(JFSAValuationReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract JFSAValuationReport.JFSAValuationReportBuilder doEvaluate(ValuationReportInstruction var1);

    public static class JFSAValuationReportFunctionDefault
    extends JFSAValuationReportFunction {
        @Override
        protected JFSAValuationReport.JFSAValuationReportBuilder doEvaluate(ValuationReportInstruction input) {
            JFSAValuationReport.JFSAValuationReportBuilder output = JFSAValuationReport.builder();
            return this.assignOutput(output, input);
        }

        protected JFSAValuationReport.JFSAValuationReportBuilder assignOutput(JFSAValuationReport.JFSAValuationReportBuilder output, ValuationReportInstruction input) {
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setDelta(this.deltaRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setTechnicalRecordIdOverriddenAsString(this.technicalRecordIdRule.evaluate(input));
            output.setReportSubmittingEntityIDOverriddenAsString(this.reportSubmittingEntityIDRule.evaluate(input));
            output.setEntityResponsibleForReportingOverriddenAsString(this.entityResponsibleForReportingRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setNewSDRIdentifier(this.newSDRIdentifierRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

