/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.margin.CommonMarginReport;
import drr.regulation.mas.rewrite.margin.meta.MASMarginReportMeta;
import drr.standards.iso.CollateralisationType3Code;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="MASMarginReport", builder=MASMarginReportBuilderImpl.class, version="7.0.0-dev.92")
@RuneDataType(value="MASMarginReport", model="drr", builder=MASMarginReportBuilderImpl.class, version="7.0.0-dev.92")
public interface MASMarginReport
extends CommonMarginReport {
    public static final MASMarginReportMeta metaData = new MASMarginReportMeta();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public String getVariationMarginCollateralPortfolioCode();

    @Override
    public CollateralisationType3Code getCollateralisationCategory();

    @Override
    public MarginActionEnum getActionType();

    @Override
    public ZonedDateTime getEventTimestamp();

    public String getUniqueTransactionIdentifierProprietary();

    public String getTechnicalRecordId();

    public String getExecutionAgentOfTheCounterparty1();

    public String getReportingSpecifiedPerson();

    @Override
    public MASMarginReport build();

    @Override
    public MASMarginReportBuilder toBuilder();

    public static MASMarginReportBuilder builder() {
        return new MASMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends MASMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MASMarginReport> getType() {
        return MASMarginReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, (Object)this.getReportingSpecifiedPerson(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MASMarginReportBuilderImpl
    extends CommonMarginReport.CommonMarginReportBuilderImpl
    implements MASMarginReportBuilder {
        protected Boolean counterparty2IdentifierType;
        protected String variationMarginCollateralPortfolioCode;
        protected CollateralisationType3Code collateralisationCategory;
        protected MarginActionEnum actionType;
        protected ZonedDateTime eventTimestamp;
        protected String uniqueTransactionIdentifierProprietary;
        protected String technicalRecordId;
        protected String executionAgentOfTheCounterparty1;
        protected String reportingSpecifiedPerson;

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory", isRequired=true)
        @RuneAttribute(value="collateralisationCategory", isRequired=true)
        public CollateralisationType3Code getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public String getReportingSpecifiedPerson() {
            return this.reportingSpecifiedPerson;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public MASMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public MASMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public MASMarginReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASMarginReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public MASMarginReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public MASMarginReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public MASMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public MASMarginReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory", isRequired=true)
        @RuneAttribute(value="collateralisationCategory", isRequired=true)
        public MASMarginReportBuilder setCollateralisationCategoryOverriddenAsCollateralisationType3Code(CollateralisationType3Code _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code _collateralisationCategory) {
            return this.setCollateralisationCategoryOverriddenAsCollateralisationType3Code(_collateralisationCategory);
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        public MASMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PreHaircut) {
            this.initialMarginPostedByTheCounterparty1PreHaircut = _initialMarginPostedByTheCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        public MASMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PostHaircut) {
            this.initialMarginPostedByTheCounterparty1PostHaircut = _initialMarginPostedByTheCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginPostedByCounterparty1Currency")
        public MASMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
            this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        public MASMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PreHaircut) {
            this.variationMarginPostedByTheCounterparty1PreHaircut = _variationMarginPostedByTheCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        public MASMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PostHaircut) {
            this.variationMarginPostedByTheCounterparty1PostHaircut = _variationMarginPostedByTheCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginPostedByCounterparty1Currency")
        public MASMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
            this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        public MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
            this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        public MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
            this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1Currency")
        public MASMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
            this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        public MASMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PreHaircut) {
            this.variationMarginCollectedByTheCounterparty1PreHaircut = _variationMarginCollectedByTheCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        public MASMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PostHaircut) {
            this.variationMarginCollectedByTheCounterparty1PostHaircut = _variationMarginCollectedByTheCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginCollectedByCounterparty1Currency")
        public MASMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
            this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralPostedByTheCounterparty1")
        public MASMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
            this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public MASMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
            this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralCollectedByTheCounterparty1")
        public MASMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
            this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public MASMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
            this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public MASMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public MASMarginReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            return this.setVariationMarginCollateralPortfolioCodeOverriddenAsString(_variationMarginCollateralPortfolioCode);
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public MASMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public MASMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MASMarginReportBuilder setActionTypeOverriddenAsMarginActionEnum(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            return this.setActionTypeOverriddenAsMarginActionEnum(_actionType);
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public MASMarginReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public MASMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            return this.setEventTimestampOverriddenAsZonedDateTime(_eventTimestamp);
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public MASMarginReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public MASMarginReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
        public MASMarginReportBuilder setExecutionAgentOfTheCounterparty1(String _executionAgentOfTheCounterparty1) {
            this.executionAgentOfTheCounterparty1 = _executionAgentOfTheCounterparty1 == null ? null : _executionAgentOfTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public MASMarginReportBuilder setReportingSpecifiedPerson(String _reportingSpecifiedPerson) {
            this.reportingSpecifiedPerson = _reportingSpecifiedPerson == null ? null : _reportingSpecifiedPerson;
            return this;
        }

        @Override
        public MASMarginReport build() {
            return new MASMarginReportImpl(this);
        }

        @Override
        public MASMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public MASMarginReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getCollateralisationCategory() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventTimestamp() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getExecutionAgentOfTheCounterparty1() != null) {
                return true;
            }
            return this.getReportingSpecifiedPerson() != null;
        }

        @Override
        public MASMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MASMarginReportBuilder o = (MASMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCodeOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralisationCategory(), (Object)o.getCollateralisationCategory(), this::setCollateralisationCategoryOverriddenAsCollateralisationType3Code, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionTypeOverriddenAsMarginActionEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfTheCounterparty1(), (Object)o.getExecutionAgentOfTheCounterparty1(), this::setExecutionAgentOfTheCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingSpecifiedPerson(), (Object)o.getReportingSpecifiedPerson(), this::setReportingSpecifiedPerson, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MASMarginReport _that = (MASMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            return Objects.equals(this.reportingSpecifiedPerson, _that.getReportingSpecifiedPerson());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.reportingSpecifiedPerson != null ? this.reportingSpecifiedPerson.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MASMarginReportBuilder {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + "} " + super.toString();
        }
    }

    public static interface MASMarginReportBuilder
    extends MASMarginReport,
    CommonMarginReport.CommonMarginReportBuilder {
        @Override
        public MASMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public MASMarginReportBuilder setCounterparty1(String var1);

        @Override
        public MASMarginReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public MASMarginReportBuilder setCounterparty2(String var1);

        @Override
        public MASMarginReportBuilder setCollateralPortfolioCode(String var1);

        @Override
        public MASMarginReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public MASMarginReportBuilder setUti(String var1);

        @Override
        public MASMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code var1);

        @Override
        public MASMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public MASMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public MASMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public MASMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String var1);

        @Override
        public MASMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal var1);

        @Override
        public MASMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String var1);

        @Override
        public MASMarginReportBuilder setCollateralTimestamp(ZonedDateTime var1);

        @Override
        public MASMarginReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public MASMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public MASMarginReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public MASMarginReportBuilder setActionType(MarginActionEnum var1);

        @Override
        public MASMarginReportBuilder setEventDate(Date var1);

        @Override
        public MASMarginReportBuilder setEventTimestamp(ZonedDateTime var1);

        public MASMarginReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public MASMarginReportBuilder setVariationMarginCollateralPortfolioCodeOverriddenAsString(String var1);

        public MASMarginReportBuilder setCollateralisationCategoryOverriddenAsCollateralisationType3Code(CollateralisationType3Code var1);

        public MASMarginReportBuilder setActionTypeOverriddenAsMarginActionEnum(MarginActionEnum var1);

        public MASMarginReportBuilder setEventTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public MASMarginReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        public MASMarginReportBuilder setTechnicalRecordId(String var1);

        public MASMarginReportBuilder setExecutionAgentOfTheCounterparty1(String var1);

        public MASMarginReportBuilder setReportingSpecifiedPerson(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingSpecifiedPerson"), String.class, (Object)this.getReportingSpecifiedPerson(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MASMarginReportBuilder prune();
    }

    public static class MASMarginReportImpl
    extends CommonMarginReport.CommonMarginReportImpl
    implements MASMarginReport {
        private final Boolean counterparty2IdentifierType;
        private final String variationMarginCollateralPortfolioCode;
        private final CollateralisationType3Code collateralisationCategory;
        private final MarginActionEnum actionType;
        private final ZonedDateTime eventTimestamp;
        private final String uniqueTransactionIdentifierProprietary;
        private final String technicalRecordId;
        private final String executionAgentOfTheCounterparty1;
        private final String reportingSpecifiedPerson;

        protected MASMarginReportImpl(MASMarginReportBuilder builder) {
            super(builder);
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.collateralisationCategory = builder.getCollateralisationCategory();
            this.actionType = builder.getActionType();
            this.eventTimestamp = builder.getEventTimestamp();
            this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.executionAgentOfTheCounterparty1 = builder.getExecutionAgentOfTheCounterparty1();
            this.reportingSpecifiedPerson = builder.getReportingSpecifiedPerson();
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        @RuneAttribute(value="variationMarginCollateralPortfolioCode", isRequired=true)
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory", isRequired=true)
        @RuneAttribute(value="collateralisationCategory", isRequired=true)
        public CollateralisationType3Code getCollateralisationCategory() {
            return this.collateralisationCategory;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp", isRequired=true)
        @RuneAttribute(value="eventTimestamp", isRequired=true)
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
        @RuneAttribute(value="executionAgentOfTheCounterparty1", isRequired=true)
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="reportingSpecifiedPerson", isRequired=true)
        @RuneAttribute(value="reportingSpecifiedPerson", isRequired=true)
        public String getReportingSpecifiedPerson() {
            return this.reportingSpecifiedPerson;
        }

        @Override
        public MASMarginReport build() {
            return this;
        }

        @Override
        public MASMarginReportBuilder toBuilder() {
            MASMarginReportBuilder builder = MASMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MASMarginReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCodeOverriddenAsString);
            Optional.ofNullable(this.getCollateralisationCategory()).ifPresent(builder::setCollateralisationCategoryOverriddenAsCollateralisationType3Code);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionTypeOverriddenAsMarginActionEnum);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getExecutionAgentOfTheCounterparty1()).ifPresent(builder::setExecutionAgentOfTheCounterparty1);
            Optional.ofNullable(this.getReportingSpecifiedPerson()).ifPresent(builder::setReportingSpecifiedPerson);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MASMarginReport _that = (MASMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals((Object)this.collateralisationCategory, (Object)_that.getCollateralisationCategory())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamp, _that.getEventTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            return Objects.equals(this.reportingSpecifiedPerson, _that.getReportingSpecifiedPerson());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.collateralisationCategory != null ? ((Object)((Object)this.collateralisationCategory)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.reportingSpecifiedPerson != null ? this.reportingSpecifiedPerson.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MASMarginReport {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", collateralisationCategory=" + String.valueOf((Object)this.collateralisationCategory) + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", technicalRecordId=" + this.technicalRecordId + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", reportingSpecifiedPerson=" + this.reportingSpecifiedPerson + "} " + super.toString();
        }
    }
}

