/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.math.Measure;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.quantity.functions.CurrencyFromNotional;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutForQuantityLeg2Rule;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import drr.standards.iosco.cde.version3.quantity.functions.Notional;
import javax.inject.Inject;

@ImplementedBy(value=NotionalCurrencyLeg2RuleDefault.class)
public abstract class NotionalCurrencyLeg2Rule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected CurrencyFromNotional currencyFromNotional;
    @Inject
    protected IsAllowableActionForMAS isAllowableActionForMAS;
    @Inject
    protected Notional notional;
    @Inject
    protected PayoutForQuantityLeg2Rule payoutForQuantityLeg2Rule;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class NotionalCurrencyLeg2RuleDefault
    extends NotionalCurrencyLeg2Rule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForMAS.evaluate((ReportableEventBase)item.get()));
            MapperS thenArg1 = MapperS.of((Object)this.notional.evaluate(this.payoutForQuantityLeg2Rule.evaluate((TransactionReportInstruction)thenArg0.get())));
            output = (ISOCurrencyCodeEnum)MapperS.of((Object)this.currencyFromNotional.evaluate((Measure)thenArg1.get())).get();
            return output;
        }
    }
}

