/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.datetime.reports;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableDates;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsCommodityFixedPriceForward;
import drr.base.qualification.product.functions.IsCommodityFloatingPriceForward;
import drr.base.qualification.product.functions.IsCommodityOption;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsCommoditySwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.util.datetime.functions.AdjustableDateResolution;
import drr.base.util.datetime.functions.AdjustableDatesResolution;
import javax.inject.Inject;

@ImplementedBy(value=ExpirationDateRuleDefault.class)
public abstract class ExpirationDateRule
implements ReportFunction<Product, Date> {
    @Inject
    protected AdjustableDateResolution adjustableDateResolution;
    @Inject
    protected AdjustableDatesResolution adjustableDatesResolution;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
    @Inject
    protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
    @Inject
    protected IsCommodityOption isCommodityOption;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsCommoditySwaption isCommoditySwaption;

    public Date evaluate(Product input) {
        Date output = this.doEvaluate(input);
        return output;
    }

    protected abstract Date doEvaluate(Product var1);

    public static class ExpirationDateRuleDefault
    extends ExpirationDateRule {
        @Override
        protected Date doEvaluate(Product input) {
            Date output = null;
            return this.assignOutput(output, input);
        }

        protected Date assignOutput(Date output, Product input) {
            output = (Date)MapperS.of((Object)input).mapSingleToItem(product -> {
                MapperS ifThenElseResult;
                MapperS thenArg0 = MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)product.get()));
                if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)thenArg0.map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get()));
                } else if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg1 = thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getCalculationPeriodDates", interestRatePayout -> interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                    ifThenElseResult = thenArg1.max();
                } else if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg2 = thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()).mapC("getExpirationDate", europeanExercise -> europeanExercise.getExpirationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                    ifThenElseResult = thenArg2.max();
                } else if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperListOfLists thenArg3 = thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise()).map("getBermudaExerciseDates", bermudaExercise -> bermudaExercise.getBermudaExerciseDates()).map("getAdjustableDates", adjustableOrRelativeDates -> adjustableOrRelativeDates.getAdjustableDates()).mapItemToList(item -> MapperC.of(this.adjustableDatesResolution.evaluate((AdjustableDates)item.get())));
                    MapperC thenArg4 = thenArg3.flattenList();
                    ifThenElseResult = thenArg4.max();
                } else if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg5 = thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getExerciseTerms", optionPayout -> optionPayout.getExerciseTerms()).map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise()).map("getExpirationDate", americanExercise -> americanExercise.getExpirationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                    ifThenElseResult = thenArg5.max();
                } else if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate()).max();
                } else if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult = thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate()).max();
                } else if (ExpressionOperatorsNullSafe.exists((Mapper)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getObservationTerms", performancePayout -> performancePayout.getObservationTerms()).map("getObservationDates", observationTerms -> observationTerms.getObservationDates()).map("getPeriodicSchedule", observationDates -> observationDates.getPeriodicSchedule()).map("getEndDate", periodicDates -> periodicDates.getEndDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    MapperC thenArg6 = thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).map("getObservationTerms", performancePayout -> performancePayout.getObservationTerms()).map("getObservationDates", observationTerms -> observationTerms.getObservationDates()).map("getPeriodicSchedule", observationDates -> observationDates.getPeriodicSchedule()).map("getEndDate", periodicDates -> periodicDates.getEndDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).mapItem(item -> MapperS.of((Object)this.adjustableDateResolution.evaluate((AdjustableDate)item.get())));
                    ifThenElseResult = thenArg6.max();
                } else {
                    Boolean _boolean;
                    ifThenElseResult = ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwap.evaluate((Product)product.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommodityFloatingPriceForward.evaluate((Product)product.get())))).getOrDefault(Boolean.valueOf(false)) != false ? thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getSchedule", commodityPayout -> commodityPayout.getSchedule()).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).max() : ((_boolean = this.isCommodityFixedPriceForward.evaluate((Product)product.get())) != null && _boolean != false ? thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).map("getSchedule", fixedPricePayout -> fixedPricePayout.getSchedule()).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).max() : (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommodityOption.evaluate((Product)product.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwaption.evaluate((Product)product.get())))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)((OptionPayout)thenArg0.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).get())).map("getSchedule", optionPayout -> optionPayout.getSchedule()).mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod()).map("getFixingPeriod", schedulePeriod -> schedulePeriod.getFixingPeriod()).map("getEndDate", dateRange -> dateRange.getEndDate()).max() : MapperS.ofNull()));
                }
                return ifThenElseResult;
            }).get();
            return output;
        }
    }
}

