/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.payment.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=OtherPaymentCurrencyRuleDefault.class)
public abstract class OtherPaymentCurrencyRule
implements ReportFunction<TransferState, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

    public ISOCurrencyCodeEnum evaluate(TransferState input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransferState var1);

    public static class OtherPaymentCurrencyRuleDefault
    extends OtherPaymentCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransferState input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransferState input) {
            MapperS thenArg = MapperS.of((Object)input).mapSingleToItem(item -> item.map("getTransfer", transferState -> transferState.getTransfer()).map("getQuantity", transfer -> transfer.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()));
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

