/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.functions.Contract_Price;
import drr.base.trade.price.functions.CurrencyPairOrCurrencyFromPrice;
import drr.standards.iosco.cde.version1.price.functions.StrikePrice;
import javax.inject.Inject;

@ImplementedBy(value=ExchangeRateBasisRuleDefault.class)
public abstract class ExchangeRateBasisRule
implements ReportFunction<TransactionReportInstructionBase, String> {
    @Inject
    protected Contract_Price contract_Price;
    @Inject
    protected CurrencyPairOrCurrencyFromPrice currencyPairOrCurrencyFromPrice;
    @Inject
    protected StrikePrice strikePrice;

    public String evaluate(TransactionReportInstructionBase input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstructionBase var1);

    public static class ExchangeRateBasisRuleDefault
    extends ExchangeRateBasisRule {
        @Override
        protected String doEvaluate(TransactionReportInstructionBase input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstructionBase input) {
            MapperC thenArg0 = MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperC.of(this.contract_Price.evaluate(input)), MapperS.of((Object)this.strikePrice.evaluate(input))}).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator())).get());
            MapperC thenArg1 = thenArg0.mapItem(item -> MapperS.of((Object)this.currencyPairOrCurrencyFromPrice.evaluate((PriceSchedule)item.get(), false)));
            output = (String)MapperS.of((Object)((String)ExpressionOperatorsNullSafe.distinct((Mapper)thenArg1).get())).get();
            return output;
        }
    }
}

