/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.TransactionReportInstructionBase;
import drr.standards.iosco.cde.version1.payment.functions.OptionPremiumOnEventDate;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=OptionPremiumCurrencyRuleDefault.class)
public abstract class OptionPremiumCurrencyRule
implements ReportFunction<TransactionReportInstructionBase, ISOCurrencyCodeEnum> {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected OptionPremiumOnEventDate optionPremiumOnEventDate;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstructionBase input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase var1);

    public static class OptionPremiumCurrencyRuleDefault
    extends OptionPremiumCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstructionBase input) {
            MapperS thenArg = MapperS.of((Object)this.optionPremiumOnEventDate.evaluate(input)).map("getQuantity", transfer -> transfer.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
            output = (ISOCurrencyCodeEnum)thenArg.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return output;
        }
    }
}

