/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.functions.CurrencyFromPrice;
import drr.standards.iosco.cde.version1.price.functions.Price;
import javax.inject.Inject;

@ImplementedBy(value=PriceCurrencyRuleDefault.class)
public abstract class PriceCurrencyRule
implements ReportFunction<TransactionReportInstructionBase, ISOCurrencyCodeEnum> {
    @Inject
    protected CurrencyFromPrice currencyFromPrice;
    @Inject
    protected Price price;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstructionBase input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase var1);

    public static class PriceCurrencyRuleDefault
    extends PriceCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstructionBase input) {
            output = this.currencyFromPrice.evaluate(this.price.evaluate(input));
            return output;
        }
    }
}

