/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.NotationFromPrice;
import drr.standards.iosco.cde.version1.price.reports.SpreadRule;
import drr.standards.iosco.cde.version1.price.reports.SpreadValueRule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadNotationEnumRuleDefault.class)
public abstract class SpreadNotationEnumRule
implements ReportFunction<PayoutLegWithAuxiliary, PriceNotationEnum> {
    @Inject
    protected NotationFromPrice notationFromPrice;
    @Inject
    protected SpreadRule spreadRule;
    @Inject
    protected SpreadValueRule spreadValueRule;

    public PriceNotationEnum evaluate(PayoutLegWithAuxiliary input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(PayoutLegWithAuxiliary var1);

    public static class SpreadNotationEnumRuleDefault
    extends SpreadNotationEnumRule {
        @Override
        protected PriceNotationEnum doEvaluate(PayoutLegWithAuxiliary input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, PayoutLegWithAuxiliary input) {
            output = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.spreadValueRule.evaluate(input))).getOrDefault(Boolean.valueOf(false)) != false ? this.notationFromPrice.evaluate(this.spreadRule.evaluate(input)) : null;
            return output;
        }
    }
}

