/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.uti.functions;

import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.functions.PositionForEvent;
import drr.base.trade.functions.TradeForEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetRegimeSpecificIdentifiers;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GetUniqueTransactionIdentifierDefault.class)
public abstract class GetUniqueTransactionIdentifier
implements RosettaFunction {
    @Inject
    protected GetRegimeSpecificIdentifiers getRegimeSpecificIdentifiers;
    @Inject
    protected PositionForEvent positionForEvent;
    @Inject
    protected TradeForEvent tradeForEvent;

    public String evaluate(ReportableInformation reportableInformation, List<SupervisoryBodyEnum> supervisoryBody, TradeIdentifier utidentifier, TransactionReportInstruction transaction) {
        String uti = this.doEvaluate(reportableInformation, supervisoryBody, utidentifier, transaction);
        return uti;
    }

    protected abstract String doEvaluate(ReportableInformation var1, List<SupervisoryBodyEnum> var2, TradeIdentifier var3, TransactionReportInstruction var4);

    protected abstract MapperC<String> utiFromReportableInformation(ReportableInformation var1, List<SupervisoryBodyEnum> var2, TradeIdentifier var3, TransactionReportInstruction var4);

    protected abstract MapperC<? extends FieldWithMetaString> utiFromTrade(ReportableInformation var1, List<SupervisoryBodyEnum> var2, TradeIdentifier var3, TransactionReportInstruction var4);

    protected abstract MapperS<? extends FieldWithMetaString> utiFromPosition(ReportableInformation var1, List<SupervisoryBodyEnum> var2, TradeIdentifier var3, TransactionReportInstruction var4);

    public static class GetUniqueTransactionIdentifierDefault
    extends GetUniqueTransactionIdentifier {
        @Override
        protected String doEvaluate(ReportableInformation reportableInformation, List<SupervisoryBodyEnum> supervisoryBody, TradeIdentifier utidentifier, TransactionReportInstruction transaction) {
            if (supervisoryBody == null) {
                supervisoryBody = Collections.emptyList();
            }
            String uti = null;
            return this.assignOutput(uti, reportableInformation, supervisoryBody, utidentifier, transaction);
        }

        protected String assignOutput(String uti, ReportableInformation reportableInformation, List<SupervisoryBodyEnum> supervisoryBody, TradeIdentifier utidentifier, TransactionReportInstruction transaction) {
            uti = (this.utiFromReportableInformation(reportableInformation, supervisoryBody, utidentifier, transaction).getMulti().isEmpty() ? this.utiFromTrade(reportableInformation, supervisoryBody, utidentifier, transaction).map("Type coercion", _fieldWithMetaString -> _fieldWithMetaString.getValue()) : this.utiFromReportableInformation(reportableInformation, supervisoryBody, utidentifier, transaction)).getMulti().isEmpty() ? (String)this.utiFromPosition(reportableInformation, supervisoryBody, utidentifier, transaction).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()).get() : (String)(this.utiFromReportableInformation(reportableInformation, supervisoryBody, utidentifier, transaction).getMulti().isEmpty() ? this.utiFromTrade(reportableInformation, supervisoryBody, utidentifier, transaction).map("Type coercion", _fieldWithMetaString -> _fieldWithMetaString.getValue()) : this.utiFromReportableInformation(reportableInformation, supervisoryBody, utidentifier, transaction)).get();
            return uti;
        }

        @Override
        protected MapperC<String> utiFromReportableInformation(ReportableInformation reportableInformation, List<SupervisoryBodyEnum> supervisoryBody, TradeIdentifier utidentifier, TransactionReportInstruction transaction) {
            return MapperC.of(this.getRegimeSpecificIdentifiers.evaluate(reportableInformation, supervisoryBody, TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER)).getMulti().isEmpty() ? MapperS.of((Object)utidentifier).mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()) : MapperC.of(this.getRegimeSpecificIdentifiers.evaluate(reportableInformation, supervisoryBody, TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER));
        }

        @Override
        protected MapperC<? extends FieldWithMetaString> utiFromTrade(ReportableInformation reportableInformation, List<SupervisoryBodyEnum> supervisoryBody, TradeIdentifier utidentifier, TransactionReportInstruction transaction) {
            MapperC thenArg = MapperS.of((Object)this.tradeForEvent.evaluate(transaction)).mapC("getTradeIdentifier", trade -> trade.getTradeIdentifier()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getIdentifierType", tradeIdentifier -> tradeIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), (CardinalityOperator)CardinalityOperator.All).get());
            return thenArg.mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier());
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> utiFromPosition(ReportableInformation reportableInformation, List<SupervisoryBodyEnum> supervisoryBody, TradeIdentifier utidentifier, TransactionReportInstruction transaction) {
            MapperC thenArg0 = MapperS.of((Object)this.positionForEvent.evaluate(transaction)).mapC("getPositionIdentifier", counterpartyPosition -> counterpartyPosition.getPositionIdentifier()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getIdentifierType", positionIdentifier -> positionIdentifier.getIdentifierType()), (Mapper)MapperS.of((Object)TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.mapC("getAssignedIdentifier", positionIdentifier -> positionIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier());
            MapperC thenArg2 = ExpressionOperatorsNullSafe.distinct((Mapper)thenArg1);
            return MapperS.of((Object)((FieldWithMetaString)thenArg2.get()));
        }
    }
}

