/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.functions;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.Abs;
import cdm.base.math.functions.RoundToPrecisionRemoveTrailingZeros;
import cdm.base.math.functions.RoundToSignificantFigures;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.inject.Inject;

@ImplementedBy(value=FormatToShortFraction5DecimalNumberDefault.class)
public abstract class FormatToShortFraction5DecimalNumber
implements RosettaFunction {
    @Inject
    protected Abs abs;
    @Inject
    protected RoundToPrecisionRemoveTrailingZeros roundToPrecisionRemoveTrailingZeros;
    @Inject
    protected RoundToSignificantFigures roundToSignificantFigures;

    public BigDecimal evaluate(BigDecimal inputNumber) {
        BigDecimal formattedNumber = this.doEvaluate(inputNumber);
        return formattedNumber;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1);

    public static class FormatToShortFraction5DecimalNumberDefault
    extends FormatToShortFraction5DecimalNumber {
        @Override
        protected BigDecimal doEvaluate(BigDecimal inputNumber) {
            BigDecimal formattedNumber = null;
            return this.assignOutput(formattedNumber, inputNumber);
        }

        protected BigDecimal assignOutput(BigDecimal formattedNumber, BigDecimal inputNumber) {
            BigInteger bigInteger = new BigInteger("9999999999999999999999999");
            if (ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)this.abs.evaluate(inputNumber)), (Mapper)(bigInteger == null ? MapperS.ofNull() : MapperS.of((Object)new BigDecimal(bigInteger))), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperS thenArg = MapperS.of((Object)this.roundToPrecisionRemoveTrailingZeros.evaluate(inputNumber, Integer.valueOf(5), RoundingDirectionEnum.NEAREST));
                formattedNumber = (BigDecimal)MapperS.of((Object)this.roundToSignificantFigures.evaluate((BigDecimal)thenArg.get(), Integer.valueOf(25), RoundingDirectionEnum.NEAREST)).get();
            } else {
                formattedNumber = inputNumber;
            }
            return formattedNumber;
        }
    }
}

