/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.DayOfWeekEnum;
import cdm.base.datetime.functions.DayOfWeek;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=IsWeekendDefault.class)
public abstract class IsWeekend
implements RosettaFunction {
    @Inject
    protected DayOfWeek dayOfWeek0;

    public Boolean evaluate(Date date, List<BusinessCenterEnum> businessCenters) {
        Boolean isWeekend = this.doEvaluate(date, businessCenters);
        return isWeekend;
    }

    protected abstract Boolean doEvaluate(Date var1, List<BusinessCenterEnum> var2);

    protected abstract MapperS<DayOfWeekEnum> dayOfWeek1(Date var1, List<BusinessCenterEnum> var2);

    public static class IsWeekendDefault
    extends IsWeekend {
        @Override
        protected Boolean doEvaluate(Date date, List<BusinessCenterEnum> businessCenters) {
            if (businessCenters == null) {
                businessCenters = Collections.emptyList();
            }
            Boolean isWeekend = null;
            return this.assignOutput(isWeekend, date, businessCenters);
        }

        protected Boolean assignOutput(Boolean isWeekend, Date date, List<BusinessCenterEnum> businessCenters) {
            isWeekend = ExpressionOperatorsNullSafe.areEqual(this.dayOfWeek1(date, businessCenters), (Mapper)MapperS.of((Object)((Object)DayOfWeekEnum.SAT)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual(this.dayOfWeek1(date, businessCenters), (Mapper)MapperS.of((Object)((Object)DayOfWeekEnum.SUN)), (CardinalityOperator)CardinalityOperator.All)).get();
            return isWeekend;
        }

        @Override
        protected MapperS<DayOfWeekEnum> dayOfWeek1(Date date, List<BusinessCenterEnum> businessCenters) {
            return MapperS.of((Object)((Object)this.dayOfWeek0.evaluate(date)));
        }
    }
}

