/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.AssetType;
import cdm.base.staticdata.asset.common.AssetTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AssetTypeSecuritySubType")
@ImplementedBy(value=Default.class)
public interface AssetTypeSecuritySubType
extends Validator<AssetType> {
    public static final String NAME = "AssetTypeSecuritySubType";
    public static final String DEFINITION = "if assetType <> AssetTypeEnum -> Security then securityType is absent and debtType is absent and equityType is absent and fundType is absent";

    public static class NoOp
    implements AssetTypeSecuritySubType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetType assetType) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AssetTypeSecuritySubType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AssetType assetType) {
            ComparisonResult result = this.executeDataRule(assetType);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AssetTypeSecuritySubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetType", (RosettaPath)path, (String)AssetTypeSecuritySubType.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AssetTypeSecuritySubType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetType", (RosettaPath)path, (String)AssetTypeSecuritySubType.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AssetType assetType) {
            try {
                if (ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)assetType).map("getAssetType", _assetType -> _assetType.getAssetType()), (Mapper)MapperS.of((Object)((Object)AssetTypeEnum.SECURITY)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)assetType).map("getSecurityType", _assetType -> _assetType.getSecurityType())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)assetType).map("getDebtType", _assetType -> _assetType.getDebtType()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)assetType).map("getEquityType", _assetType -> _assetType.getEquityType()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)assetType).map("getFundType", _assetType -> _assetType.getFundType())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

