/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CreditEventTypeEnum")
public enum CreditEventTypeEnum {
    BANKRUPTCY("Bankruptcy", null),
    DISTRESSED_RATINGS_DOWNGRADE("DistressedRatingsDowngrade", null),
    FAILURE_TO_PAY("FailureToPay", null),
    FAILURE_TO_PAY_INTEREST("FailureToPayInterest", null),
    FAILURE_TO_PAY_PRINCIPAL("FailureToPayPrincipal", null),
    GOVERNMENTAL_INTERVENTION("GovernmentalIntervention", null),
    IMPLIED_WRITEDOWN("ImpliedWritedown", null),
    MATURITY_EXTENSION("MaturityExtension", null),
    OBLIGATION_ACCELERATION("ObligationAcceleration", null),
    OBLIGATION_DEFAULT("ObligationDefault", null),
    REPUDIATION_MORATORIUM("RepudiationMoratorium", null),
    RESTRUCTURING("Restructuring", null),
    WRITEDOWN("Writedown", null);

    private static Map<String, CreditEventTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private CreditEventTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CreditEventTypeEnum fromDisplayName(String name) {
        CreditEventTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CreditEventTypeEnum> map = new ConcurrentHashMap<String, CreditEventTypeEnum>();
        for (CreditEventTypeEnum instance : CreditEventTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

