/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.functions.ExtractAfterTradableProduct;
import cdm.event.common.functions.ExtractBeforeEconomicTerms;
import cdm.event.common.functions.ExtractBeforeTradableProduct;
import cdm.event.common.functions.ExtractOpenEconomicTerms;
import cdm.event.common.functions.ExtractTradeCollateralPrice;
import cdm.event.common.functions.ExtractTradeCollateralQuantity;
import cdm.event.common.functions.ExtractTradePurchasePrice;
import cdm.event.common.functions.FilterClosedTradeStates;
import cdm.event.common.functions.FilterOpenTradeStates;
import cdm.product.template.EconomicTerms;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=Qualify_RepriceDefault.class)
public abstract class Qualify_Reprice
implements RosettaFunction,
IQualifyFunctionExtension<BusinessEvent> {
    @Inject
    protected ExtractAfterTradableProduct extractAfterTradableProduct;
    @Inject
    protected ExtractBeforeEconomicTerms extractBeforeEconomicTerms;
    @Inject
    protected ExtractBeforeTradableProduct extractBeforeTradableProduct;
    @Inject
    protected ExtractOpenEconomicTerms extractOpenEconomicTerms;
    @Inject
    protected ExtractTradeCollateralPrice extractTradeCollateralPrice;
    @Inject
    protected ExtractTradeCollateralQuantity extractTradeCollateralQuantity;
    @Inject
    protected ExtractTradePurchasePrice extractTradePurchasePrice;
    @Inject
    protected FilterClosedTradeStates filterClosedTradeStates;
    @Inject
    protected FilterOpenTradeStates filterOpenTradeStates;

    public Boolean evaluate(BusinessEvent businessEvent) {
        Boolean is_event = this.doEvaluate(businessEvent);
        return is_event;
    }

    protected abstract Boolean doEvaluate(BusinessEvent var1);

    protected abstract MapperC<? extends Trade> openTrades(BusinessEvent var1);

    protected abstract MapperC<? extends TradeState> closedTradeState(BusinessEvent var1);

    protected abstract MapperS<? extends TradableProduct> beforeTradableProduct(BusinessEvent var1);

    protected abstract MapperS<? extends TradableProduct> afterTradableProduct(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> beforeTradePurchasePrice(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> afterTradePurchasePrice(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> afterTradeCollateralQuantity(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> beforeTradeCollateralPrice(BusinessEvent var1);

    protected abstract MapperC<BigDecimal> afterTradeCollateralPrice(BusinessEvent var1);

    protected abstract MapperS<? extends EconomicTerms> beforeEconomicterms(BusinessEvent var1);

    protected abstract MapperS<? extends EconomicTerms> openEconomicTerms(BusinessEvent var1);

    public String getNamePrefix() {
        return "Qualify";
    }

    public static class Qualify_RepriceDefault
    extends Qualify_Reprice {
        @Override
        protected Boolean doEvaluate(BusinessEvent businessEvent) {
            Boolean is_event = null;
            return this.assignOutput(is_event, businessEvent);
        }

        protected Boolean assignOutput(Boolean is_event, BusinessEvent businessEvent) {
            is_event = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).map("getTrade", tradeState -> tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.openTrades(businessEvent).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.closedTradeState(businessEvent).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.exists(this.beforeTradePurchasePrice(businessEvent))).andNullSafe(ExpressionOperatorsNullSafe.exists(this.afterTradePurchasePrice(businessEvent))).andNullSafe(ExpressionOperatorsNullSafe.notEqual(this.afterTradePurchasePrice(businessEvent), this.beforeTradePurchasePrice(businessEvent), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.areEqual(this.beforeTradeCollateralQuantity(businessEvent), this.afterTradeCollateralQuantity(businessEvent), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.notEqual(this.beforeTradeCollateralPrice(businessEvent), this.afterTradeCollateralPrice(businessEvent), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.exists(this.beforeEconomicterms(businessEvent))).andNullSafe(ExpressionOperatorsNullSafe.exists(this.openEconomicTerms(businessEvent))).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.openEconomicTerms(businessEvent).map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), (Mapper)this.beforeEconomicterms(businessEvent).map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()), (CardinalityOperator)CardinalityOperator.All)).get();
            return is_event;
        }

        @Override
        protected MapperC<? extends Trade> openTrades(BusinessEvent businessEvent) {
            return MapperC.of(this.filterOpenTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti())).map("getTrade", tradeState -> tradeState.getTrade());
        }

        @Override
        protected MapperC<? extends TradeState> closedTradeState(BusinessEvent businessEvent) {
            return MapperC.of(this.filterClosedTradeStates.evaluate(MapperS.of((Object)businessEvent).mapC("getAfter", _businessEvent -> _businessEvent.getAfter()).getMulti()));
        }

        @Override
        protected MapperS<? extends TradableProduct> beforeTradableProduct(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractBeforeTradableProduct.evaluate(businessEvent));
        }

        @Override
        protected MapperS<? extends TradableProduct> afterTradableProduct(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractAfterTradableProduct.evaluate(businessEvent));
        }

        @Override
        protected MapperC<BigDecimal> beforeTradePurchasePrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradePurchasePrice.evaluate((TradableProduct)this.beforeTradableProduct(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> afterTradePurchasePrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradePurchasePrice.evaluate((TradableProduct)this.afterTradableProduct(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> beforeTradeCollateralQuantity(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralQuantity.evaluate((TradableProduct)this.beforeTradableProduct(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> afterTradeCollateralQuantity(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralQuantity.evaluate((TradableProduct)this.afterTradableProduct(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> beforeTradeCollateralPrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralPrice.evaluate((TradableProduct)this.beforeTradableProduct(businessEvent).get()));
        }

        @Override
        protected MapperC<BigDecimal> afterTradeCollateralPrice(BusinessEvent businessEvent) {
            return MapperC.of(this.extractTradeCollateralPrice.evaluate((TradableProduct)this.afterTradableProduct(businessEvent).get()));
        }

        @Override
        protected MapperS<? extends EconomicTerms> beforeEconomicterms(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractBeforeEconomicTerms.evaluate(businessEvent));
        }

        @Override
        protected MapperS<? extends EconomicTerms> openEconomicTerms(BusinessEvent businessEvent) {
            return MapperS.of((Object)this.extractOpenEconomicTerms.evaluate(businessEvent));
        }
    }
}

