/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.CollateralPosition;
import cdm.event.common.CollateralStatusEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CollateralPositionCollateralPositionStatusSettledOrInTransitOnly")
@ImplementedBy(value=Default.class)
public interface CollateralPositionCollateralPositionStatusSettledOrInTransitOnly
extends Validator<CollateralPosition> {
    public static final String NAME = "CollateralPositionCollateralPositionStatusSettledOrInTransitOnly";
    public static final String DEFINITION = "if collateralPositionStatus exists then collateralPositionStatus = CollateralStatusEnum -> SettledAmount or collateralPositionStatus = CollateralStatusEnum -> InTransitAmount";

    public static class NoOp
    implements CollateralPositionCollateralPositionStatusSettledOrInTransitOnly {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralPosition collateralPosition) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CollateralPositionCollateralPositionStatusSettledOrInTransitOnly {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralPosition collateralPosition) {
            ComparisonResult result = this.executeDataRule(collateralPosition);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralPosition", (RosettaPath)path, (String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralPosition", (RosettaPath)path, (String)CollateralPositionCollateralPositionStatusSettledOrInTransitOnly.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CollateralPosition collateralPosition) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)collateralPosition).map("getCollateralPositionStatus", _collateralPosition -> _collateralPosition.getCollateralPositionStatus())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)collateralPosition).map("getCollateralPositionStatus", _collateralPosition -> _collateralPosition.getCollateralPositionStatus()), (Mapper)MapperS.of((Object)((Object)CollateralStatusEnum.SETTLED_AMOUNT)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)collateralPosition).map("getCollateralPositionStatus", _collateralPosition -> _collateralPosition.getCollateralPositionStatus()), (Mapper)MapperS.of((Object)((Object)CollateralStatusEnum.IN_TRANSIT_AMOUNT)), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

